/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.circuitbreaker;

import com.linecorp.armeria.client.circuitbreaker.CircuitBreaker;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerConfig;
import com.linecorp.armeria.client.circuitbreaker.CircuitState;
import com.linecorp.armeria.client.circuitbreaker.EventCount;
import com.linecorp.armeria.client.circuitbreaker.EventCounter;
import com.linecorp.armeria.client.circuitbreaker.SlidingWindowCounter;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Ticker;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NonBlockingCircuitBreaker
implements CircuitBreaker {
    private static final Logger logger = LoggerFactory.getLogger(NonBlockingCircuitBreaker.class);
    private static final AtomicLong seqNo = new AtomicLong(0L);
    private final String name;
    private final CircuitBreakerConfig config;
    private final AtomicReference<State> state;
    private final Ticker ticker;

    NonBlockingCircuitBreaker(Ticker ticker, CircuitBreakerConfig config) {
        this.ticker = Objects.requireNonNull(ticker, "ticker");
        this.config = Objects.requireNonNull(config, "config");
        this.name = config.name().orElseGet(() -> "circuit-breaker-" + seqNo.getAndIncrement());
        this.state = new AtomicReference<State>(this.newClosedState());
        this.logStateTransition(CircuitState.CLOSED, null);
        this.notifyStateChanged(CircuitState.CLOSED);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void onSuccess() {
        State currentState = this.state.get();
        if (currentState.isClosed()) {
            Optional<EventCount> updatedCount = currentState.counter().onSuccess();
            updatedCount.ifPresent(this::notifyCountUpdated);
        } else if (currentState.isHalfOpen() && this.state.compareAndSet(currentState, this.newClosedState())) {
            this.logStateTransition(CircuitState.CLOSED, null);
            this.notifyStateChanged(CircuitState.CLOSED);
        }
    }

    @Override
    public void onFailure() {
        State currentState = this.state.get();
        if (currentState.isClosed()) {
            Optional<EventCount> updatedCount = currentState.counter().onFailure();
            updatedCount.ifPresent(count -> {
                if (this.checkIfExceedingFailureThreshold((EventCount)count) && this.state.compareAndSet(currentState, this.newOpenState())) {
                    this.logStateTransition(CircuitState.OPEN, (EventCount)count);
                    this.notifyStateChanged(CircuitState.OPEN);
                } else {
                    this.notifyCountUpdated((EventCount)count);
                }
            });
        } else if (currentState.isHalfOpen() && this.state.compareAndSet(currentState, this.newOpenState())) {
            this.logStateTransition(CircuitState.OPEN, null);
            this.notifyStateChanged(CircuitState.OPEN);
        }
    }

    private boolean checkIfExceedingFailureThreshold(EventCount count) {
        return 0L < count.total() && this.config.minimumRequestThreshold() <= count.total() && this.config.failureRateThreshold() < count.failureRate();
    }

    @Override
    public boolean canRequest() {
        State currentState = this.state.get();
        if (currentState.isClosed()) {
            return true;
        }
        if (currentState.isHalfOpen() || currentState.isOpen()) {
            if (currentState.checkTimeout() && this.state.compareAndSet(currentState, this.newHalfOpenState())) {
                this.logStateTransition(CircuitState.HALF_OPEN, null);
                this.notifyStateChanged(CircuitState.HALF_OPEN);
                return true;
            }
            this.notifyRequestRejected();
            return false;
        }
        return true;
    }

    private State newOpenState() {
        return new State(CircuitState.OPEN, this.config.circuitOpenWindow(), NoOpCounter.INSTANCE);
    }

    private State newHalfOpenState() {
        return new State(CircuitState.HALF_OPEN, this.config.trialRequestInterval(), NoOpCounter.INSTANCE);
    }

    private State newClosedState() {
        return new State(CircuitState.CLOSED, Duration.ZERO, new SlidingWindowCounter(this.ticker, this.config.counterSlidingWindow(), this.config.counterUpdateInterval()));
    }

    private void logStateTransition(CircuitState circuitState, @Nullable EventCount count) {
        if (logger.isInfoEnabled()) {
            int capacity = this.name.length() + circuitState.name().length() + 32;
            StringBuilder builder = new StringBuilder(capacity);
            builder.append("name:");
            builder.append(this.name);
            builder.append(" state:");
            builder.append(circuitState.name());
            if (count != null) {
                builder.append(" fail:");
                builder.append(count.failure());
                builder.append(" total:");
                builder.append(count.total());
            }
            logger.info(builder.toString());
        }
    }

    private void notifyStateChanged(CircuitState circuitState) {
        this.config.listeners().forEach(listener -> {
            try {
                listener.onStateChanged(this, circuitState);
            }
            catch (Throwable t) {
                logger.warn("An error occurred when notifying a StateChanged event", t);
            }
            try {
                listener.onEventCountUpdated(this, EventCount.ZERO);
            }
            catch (Throwable t) {
                logger.warn("An error occurred when notifying an EventCountUpdated event", t);
            }
        });
    }

    private void notifyCountUpdated(EventCount count) {
        this.config.listeners().forEach(listener -> {
            try {
                listener.onEventCountUpdated(this, count);
            }
            catch (Throwable t) {
                logger.warn("An error occurred when notifying an EventCountUpdated event", t);
            }
        });
    }

    private void notifyRequestRejected() {
        this.config.listeners().forEach(listener -> {
            try {
                listener.onRequestRejected(this);
            }
            catch (Throwable t) {
                logger.warn("An error occurred when notifying a RequestRejected event", t);
            }
        });
    }

    State state() {
        return this.state.get();
    }

    CircuitBreakerConfig config() {
        return this.config;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("config", this.config).toString();
    }

    private static class NoOpCounter
    implements EventCounter {
        private static final NoOpCounter INSTANCE = new NoOpCounter();

        private NoOpCounter() {
        }

        @Override
        public EventCount count() {
            return EventCount.ZERO;
        }

        @Override
        public Optional<EventCount> onSuccess() {
            return Optional.empty();
        }

        @Override
        public Optional<EventCount> onFailure() {
            return Optional.empty();
        }
    }

    final class State {
        private final CircuitState circuitState;
        private final EventCounter counter;
        private final long timedOutTimeNanos;

        private State(CircuitState circuitState, Duration timeoutDuration, EventCounter counter) {
            this.circuitState = circuitState;
            this.counter = counter;
            this.timedOutTimeNanos = timeoutDuration.isZero() || timeoutDuration.isNegative() ? 0L : NonBlockingCircuitBreaker.this.ticker.read() + timeoutDuration.toNanos();
        }

        private EventCounter counter() {
            return this.counter;
        }

        private boolean checkTimeout() {
            return 0L < this.timedOutTimeNanos && this.timedOutTimeNanos <= NonBlockingCircuitBreaker.this.ticker.read();
        }

        boolean isOpen() {
            return this.circuitState == CircuitState.OPEN;
        }

        boolean isHalfOpen() {
            return this.circuitState == CircuitState.HALF_OPEN;
        }

        boolean isClosed() {
            return this.circuitState == CircuitState.CLOSED;
        }
    }
}

