/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.encoding;

import com.linecorp.armeria.client.encoding.StreamDecoder;
import com.linecorp.armeria.client.encoding.StreamDecoderFactory;
import com.linecorp.armeria.common.FilteredHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.HttpStatusClass;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import java.util.Map;
import javax.annotation.Nullable;
import org.reactivestreams.Subscriber;

class HttpDecodedResponse
extends FilteredHttpResponse {
    private final Map<String, StreamDecoderFactory> availableDecoders;
    @Nullable
    private StreamDecoder responseDecoder;
    private boolean headersReceived;

    HttpDecodedResponse(HttpResponse delegate, Map<String, StreamDecoderFactory> availableDecoders) {
        super(delegate);
        this.availableDecoders = availableDecoders;
    }

    @Override
    protected HttpObject filter(HttpObject obj) {
        if (obj instanceof HttpHeaders) {
            StreamDecoderFactory decoderFactory;
            HttpHeaders headers = (HttpHeaders)obj;
            HttpStatus status = headers.status();
            if (status != null && status.codeClass() == HttpStatusClass.INFORMATIONAL) {
                return obj;
            }
            if (this.headersReceived) {
                return obj;
            }
            if (status == null) {
                return obj;
            }
            this.headersReceived = true;
            String contentEncoding = (String)headers.get(HttpHeaderNames.CONTENT_ENCODING);
            if (contentEncoding != null && (decoderFactory = this.availableDecoders.get(Ascii.toLowerCase(contentEncoding))) != null) {
                this.responseDecoder = decoderFactory.newDecoder();
            }
            return headers;
        }
        assert (obj instanceof HttpData);
        return this.responseDecoder != null ? this.responseDecoder.decode((HttpData)obj) : obj;
    }

    @Override
    protected void beforeComplete(Subscriber<? super HttpObject> subscriber) {
        if (this.responseDecoder == null) {
            return;
        }
        HttpData lastData = this.responseDecoder.finish();
        if (!lastData.isEmpty()) {
            subscriber.onNext((Object)lastData);
        }
    }

    @Override
    protected Throwable beforeError(Subscriber<? super HttpObject> subscriber, Throwable cause) {
        if (this.responseDecoder != null) {
            this.responseDecoder.finish();
        }
        return cause;
    }
}

