/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.encoding;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.SimpleDecoratingClient;
import com.linecorp.armeria.client.encoding.DeflateStreamDecoderFactory;
import com.linecorp.armeria.client.encoding.GzipStreamDecoderFactory;
import com.linecorp.armeria.client.encoding.HttpDecodedResponse;
import com.linecorp.armeria.client.encoding.StreamDecoderFactory;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.Streams;
import java.util.Map;
import java.util.function.Function;

public final class HttpDecodingClient
extends SimpleDecoratingClient<HttpRequest, HttpResponse> {
    private final Map<String, StreamDecoderFactory> decoderFactories;
    private final String acceptEncodingHeader;

    public static Function<Client<HttpRequest, HttpResponse>, HttpDecodingClient> newDecorator() {
        return HttpDecodingClient.newDecorator(ImmutableList.of(new GzipStreamDecoderFactory(), new DeflateStreamDecoderFactory()));
    }

    public static Function<Client<HttpRequest, HttpResponse>, HttpDecodingClient> newDecorator(StreamDecoderFactory ... decoderFactories) {
        return HttpDecodingClient.newDecorator(ImmutableList.copyOf(decoderFactories));
    }

    public static Function<Client<HttpRequest, HttpResponse>, HttpDecodingClient> newDecorator(Iterable<? extends StreamDecoderFactory> decoderFactories) {
        return client -> new HttpDecodingClient((Client<HttpRequest, HttpResponse>)client, decoderFactories);
    }

    private HttpDecodingClient(Client<HttpRequest, HttpResponse> delegate, Iterable<? extends StreamDecoderFactory> decoderFactories) {
        super(delegate);
        this.decoderFactories = Streams.stream(decoderFactories).collect(ImmutableMap.toImmutableMap(StreamDecoderFactory::encodingHeaderValue, Function.identity()));
        this.acceptEncodingHeader = String.join((CharSequence)",", this.decoderFactories.keySet());
    }

    @Override
    public HttpResponse execute(ClientRequestContext ctx, HttpRequest req) throws Exception {
        if (req.headers().contains(HttpHeaderNames.ACCEPT_ENCODING)) {
            return (HttpResponse)this.delegate().execute(ctx, (HttpRequest)req);
        }
        req.headers().set(HttpHeaderNames.ACCEPT_ENCODING, this.acceptEncodingHeader);
        HttpResponse res = (HttpResponse)this.delegate().execute(ctx, (HttpRequest)req);
        return new HttpDecodedResponse(res, this.decoderFactories);
    }
}

