/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.encoding;

import com.linecorp.armeria.client.encoding.StreamDecoder;
import com.linecorp.armeria.common.HttpData;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;

class ZlibStreamDecoder
implements StreamDecoder {
    private final EmbeddedChannel decoder;

    ZlibStreamDecoder(ZlibWrapper zlibWrapper) {
        this.decoder = new EmbeddedChannel(false, new ChannelHandler[]{ZlibCodecFactory.newZlibDecoder((ZlibWrapper)zlibWrapper)});
    }

    @Override
    public HttpData decode(HttpData obj) {
        if (obj instanceof ByteBufHolder) {
            this.decoder.writeInbound(new Object[]{((ByteBufHolder)obj).content()});
        } else {
            ByteBuf compressed = Unpooled.wrappedBuffer((byte[])obj.array(), (int)obj.offset(), (int)obj.length());
            this.decoder.writeInbound(new Object[]{compressed});
        }
        return HttpData.of(this.fetchDecoderOutput());
    }

    @Override
    public HttpData finish() {
        if (this.decoder.finish()) {
            return HttpData.of(this.fetchDecoderOutput());
        }
        return HttpData.EMPTY_DATA;
    }

    private byte[] fetchDecoderOutput() {
        ByteBuf buf;
        CompositeByteBuf decoded = Unpooled.compositeBuffer();
        while ((buf = (ByteBuf)this.decoder.readInbound()) != null) {
            if (!buf.isReadable()) {
                buf.release();
                continue;
            }
            decoded.addComponent(true, buf);
        }
        byte[] ret = ByteBufUtil.getBytes((ByteBuf)decoded);
        decoded.release();
        return ret;
    }
}

