/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.common.util.AbstractListenable;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DynamicEndpointGroup
extends AbstractListenable<List<Endpoint>>
implements EndpointGroup {
    private volatile List<Endpoint> endpoints = ImmutableList.of();
    private final Lock endpointsLock = new ReentrantLock();
    private final CompletableFuture<List<Endpoint>> initialEndpointsFuture = new CompletableFuture();

    @Override
    public final List<Endpoint> endpoints() {
        return this.endpoints;
    }

    public CompletableFuture<List<Endpoint>> initialEndpointsFuture() {
        return this.initialEndpointsFuture;
    }

    public List<Endpoint> awaitInitialEndpoints() throws InterruptedException {
        try {
            return this.initialEndpointsFuture.get();
        }
        catch (ExecutionException e) {
            throw new CompletionException(e.getCause());
        }
    }

    public List<Endpoint> awaitInitialEndpoints(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        try {
            return this.initialEndpointsFuture.get(timeout, unit);
        }
        catch (ExecutionException e) {
            throw new CompletionException(e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addEndpoint(Endpoint e) {
        ImmutableList<Endpoint> newEndpoints;
        this.endpointsLock.lock();
        try {
            ArrayList<Endpoint> newEndpointsUnsorted = Lists.newArrayList(this.endpoints);
            newEndpointsUnsorted.add(e);
            newEndpoints = ImmutableList.sortedCopyOf(newEndpointsUnsorted);
            this.endpoints = newEndpoints;
        }
        finally {
            this.endpointsLock.unlock();
        }
        this.notifyListeners(newEndpoints);
        this.completeInitialEndpointsFuture(newEndpoints);
    }

    protected final void removeEndpoint(Endpoint e) {
        List newEndpoints;
        this.endpointsLock.lock();
        try {
            this.endpoints = newEndpoints = (List)this.endpoints.stream().filter(endpoint -> !endpoint.equals(e)).collect(ImmutableList.toImmutableList());
        }
        finally {
            this.endpointsLock.unlock();
        }
        this.notifyListeners(newEndpoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setEndpoints(Iterable<Endpoint> endpoints) {
        List<Endpoint> oldEndpoints = this.endpoints;
        ImmutableList<Endpoint> newEndpoints = ImmutableList.sortedCopyOf(endpoints);
        if (oldEndpoints.equals(newEndpoints)) {
            return;
        }
        this.endpointsLock.lock();
        try {
            this.endpoints = newEndpoints;
        }
        finally {
            this.endpointsLock.unlock();
        }
        this.notifyListeners(newEndpoints);
        this.completeInitialEndpointsFuture(newEndpoints);
    }

    private void completeInitialEndpointsFuture(List<Endpoint> endpoints) {
        if (!endpoints.isEmpty() && !this.initialEndpointsFuture.isDone()) {
            this.initialEndpointsFuture.complete(endpoints);
        }
    }

    @Override
    public void close() {
        if (!this.initialEndpointsFuture.isDone()) {
            this.initialEndpointsFuture.cancel(true);
        }
    }
}

