/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointGroupException;
import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.armeria.client.endpoint.EndpointSelector;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class EndpointGroupRegistry {
    private static final Pattern GROUP_NAME_PATTERN = Pattern.compile("^[-_.0-9a-z]+$");
    private static final Map<String, EndpointSelector> serverGroups = new ConcurrentHashMap<String, EndpointSelector>();

    public static boolean register(String groupName, EndpointGroup endpointGroup, EndpointSelectionStrategy endpointSelectionStrategy) {
        if (!GROUP_NAME_PATTERN.matcher(groupName = EndpointGroupRegistry.normalizeGroupName(groupName)).matches()) {
            throw new IllegalArgumentException("groupName: " + groupName + " (expected: " + GROUP_NAME_PATTERN.pattern() + ')');
        }
        Objects.requireNonNull(endpointGroup, "group");
        Objects.requireNonNull(endpointSelectionStrategy, "endpointSelectionStrategy");
        EndpointSelector oldSelector = serverGroups.put(groupName, endpointSelectionStrategy.newSelector(endpointGroup));
        return oldSelector == null;
    }

    public static boolean unregister(String groupName) {
        return serverGroups.remove(groupName = EndpointGroupRegistry.normalizeGroupName(groupName)) != null;
    }

    @Nullable
    public static EndpointSelector getNodeSelector(String groupName) {
        groupName = EndpointGroupRegistry.normalizeGroupName(groupName);
        return serverGroups.get(groupName);
    }

    @Nullable
    public static EndpointGroup get(String groupName) {
        EndpointSelector endpointSelector = serverGroups.get(groupName = EndpointGroupRegistry.normalizeGroupName(groupName));
        if (endpointSelector == null) {
            return null;
        }
        return endpointSelector.group();
    }

    public static Endpoint selectNode(ClientRequestContext ctx, String groupName) {
        EndpointSelector endpointSelector = EndpointGroupRegistry.getNodeSelector(groupName = EndpointGroupRegistry.normalizeGroupName(groupName));
        if (endpointSelector == null) {
            throw new EndpointGroupException("non-existent EndpointGroup: " + groupName);
        }
        return endpointSelector.select(ctx);
    }

    private static String normalizeGroupName(String groupName) {
        return Ascii.toLowerCase(Objects.requireNonNull(groupName, "groupName"));
    }

    private EndpointGroupRegistry() {
    }
}

