/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public final class PropertiesEndpointGroup
implements EndpointGroup {
    private final List<Endpoint> endpoints;

    public static PropertiesEndpointGroup of(ClassLoader classLoader, String resourceName, String endpointKeyPrefix) {
        return new PropertiesEndpointGroup(PropertiesEndpointGroup.loadEndpoints(Objects.requireNonNull(classLoader, "classLoader"), Objects.requireNonNull(resourceName, "resourceName"), Objects.requireNonNull(endpointKeyPrefix, "endpointKeyPrefix"), 0));
    }

    public static PropertiesEndpointGroup of(ClassLoader classLoader, String resourceName, String endpointKeyPrefix, int defaultPort) {
        PropertiesEndpointGroup.validateDefaultPort(defaultPort);
        return new PropertiesEndpointGroup(PropertiesEndpointGroup.loadEndpoints(Objects.requireNonNull(classLoader, "classLoader"), Objects.requireNonNull(resourceName, "resourceName"), Objects.requireNonNull(endpointKeyPrefix, "endpointKeyPrefix"), defaultPort));
    }

    public static PropertiesEndpointGroup of(Properties properties, String endpointKeyPrefix) {
        return new PropertiesEndpointGroup(PropertiesEndpointGroup.loadEndpoints(Objects.requireNonNull(properties, "properties"), Objects.requireNonNull(endpointKeyPrefix, "endpointKeyPrefix"), 0));
    }

    public static PropertiesEndpointGroup of(Properties properties, String endpointKeyPrefix, int defaultPort) {
        PropertiesEndpointGroup.validateDefaultPort(defaultPort);
        return new PropertiesEndpointGroup(PropertiesEndpointGroup.loadEndpoints(Objects.requireNonNull(properties, "properties"), Objects.requireNonNull(endpointKeyPrefix, "endpointKeyPrefix"), defaultPort));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Endpoint> loadEndpoints(ClassLoader classLoader, String resourceName, String endpointKeyPrefix, int defaultPort) {
        URL resourceUrl = classLoader.getResource(resourceName);
        Preconditions.checkArgument(resourceUrl != null, "resource not found: %s", (Object)resourceName);
        if (!endpointKeyPrefix.endsWith(".")) {
            endpointKeyPrefix = endpointKeyPrefix + ".";
        }
        try (InputStream in = resourceUrl.openStream();){
            Properties props = new Properties();
            props.load(in);
            List<Endpoint> list = PropertiesEndpointGroup.loadEndpoints(props, endpointKeyPrefix, defaultPort);
            return list;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("failed to load: " + resourceName, e);
        }
    }

    private static List<Endpoint> loadEndpoints(Properties properties, String endpointKeyPrefix, int defaultPort) {
        ArrayList<Endpoint> newEndpoints = new ArrayList<Endpoint>();
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            if (!key.startsWith(endpointKeyPrefix)) continue;
            Endpoint endpoint = Endpoint.parse(value);
            Preconditions.checkState(!endpoint.isGroup(), "properties contains an endpoint group which is not allowed: %s in %s", value, properties);
            newEndpoints.add(defaultPort == 0 ? endpoint : endpoint.withDefaultPort(defaultPort));
        }
        Preconditions.checkArgument(!newEndpoints.isEmpty(), "properties contains no hosts: %s", (Object)properties);
        return ImmutableList.copyOf(newEndpoints);
    }

    private static void validateDefaultPort(int defaultPort) {
        Preconditions.checkArgument(defaultPort > 0 && defaultPort <= 65535, "defaultPort: %s (expected: 1-65535)", defaultPort);
    }

    private PropertiesEndpointGroup(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    @Override
    public List<Endpoint> endpoints() {
        return this.endpoints;
    }
}

