/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointGroupException;
import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.armeria.client.endpoint.EndpointSelector;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

final class RoundRobinStrategy
implements EndpointSelectionStrategy {
    RoundRobinStrategy() {
    }

    @Override
    public EndpointSelector newSelector(EndpointGroup endpointGroup) {
        return new RoundRobinSelector(endpointGroup);
    }

    static class RoundRobinSelector
    implements EndpointSelector {
        private final EndpointGroup endpointGroup;
        private final AtomicInteger sequence = new AtomicInteger();

        RoundRobinSelector(EndpointGroup endpointGroup) {
            this.endpointGroup = Objects.requireNonNull(endpointGroup, "endpointGroup");
        }

        @Override
        public EndpointGroup group() {
            return this.endpointGroup;
        }

        @Override
        public EndpointSelectionStrategy strategy() {
            return EndpointSelectionStrategy.ROUND_ROBIN;
        }

        @Override
        public Endpoint select(ClientRequestContext ctx) {
            List<Endpoint> endpoints = this.endpointGroup.endpoints();
            int currentSequence = this.sequence.getAndIncrement();
            if (endpoints.isEmpty()) {
                throw new EndpointGroupException(this.endpointGroup + " is empty");
            }
            return endpoints.get(Math.abs(currentSequence % endpoints.size()));
        }
    }
}

