/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointGroupException;
import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.armeria.client.endpoint.EndpointSelector;
import com.linecorp.armeria.internal.shaded.guava.hash.Hashing;
import java.util.List;
import java.util.Objects;
import java.util.function.ToLongFunction;

public final class StickyEndpointSelectionStrategy
implements EndpointSelectionStrategy {
    private final ToLongFunction<ClientRequestContext> requestContextHasher;

    public StickyEndpointSelectionStrategy(ToLongFunction<ClientRequestContext> requestContextHasher) {
        this.requestContextHasher = Objects.requireNonNull(requestContextHasher, "requestContextHasher");
    }

    @Override
    public EndpointSelector newSelector(EndpointGroup endpointGroup) {
        return new StickyEndpointSelector(this.requestContextHasher, endpointGroup);
    }

    private final class StickyEndpointSelector
    implements EndpointSelector {
        private final ToLongFunction<ClientRequestContext> requestContextHasher;
        private final EndpointGroup endpointGroup;

        StickyEndpointSelector(ToLongFunction<ClientRequestContext> requestContextHasher, EndpointGroup endpointGroup) {
            this.requestContextHasher = Objects.requireNonNull(requestContextHasher, "requestContextHasher");
            this.endpointGroup = Objects.requireNonNull(endpointGroup, "endpointGroup");
        }

        @Override
        public EndpointGroup group() {
            return this.endpointGroup;
        }

        @Override
        public EndpointSelectionStrategy strategy() {
            return StickyEndpointSelectionStrategy.this;
        }

        @Override
        public Endpoint select(ClientRequestContext ctx) {
            List<Endpoint> endpoints = this.endpointGroup.endpoints();
            if (endpoints.isEmpty()) {
                throw new EndpointGroupException(this.endpointGroup + " is empty");
            }
            long key = this.requestContextHasher.applyAsLong(ctx);
            int nearest = Hashing.consistentHash(key, endpoints.size());
            return endpoints.get(nearest);
        }
    }
}

