/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint.dns;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.dns.DnsAddressEndpointGroupBuilder;
import com.linecorp.armeria.client.endpoint.dns.DnsEndpointGroup;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSortedSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRawRecord;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.util.NetUtil;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class DnsAddressEndpointGroup
extends DnsEndpointGroup {
    private final String hostname;
    private final int port;

    public static DnsAddressEndpointGroup of(String hostname) {
        return new DnsAddressEndpointGroupBuilder(hostname).build();
    }

    public static DnsAddressEndpointGroup of(String hostname, int port) {
        return new DnsAddressEndpointGroupBuilder(hostname).port(port).build();
    }

    DnsAddressEndpointGroup(EventLoop eventLoop, int minTtl, int maxTtl, DnsServerAddressStreamProvider serverAddressStreamProvider, Backoff backoff, @Nullable ResolvedAddressTypes resolvedAddressTypes, String hostname, int port) {
        super(eventLoop, minTtl, maxTtl, serverAddressStreamProvider, backoff, DnsAddressEndpointGroup.newQuestions(hostname, resolvedAddressTypes), resolverBuilder -> {
            if (resolvedAddressTypes != null) {
                resolverBuilder.resolvedAddressTypes(resolvedAddressTypes);
            }
        });
        this.hostname = hostname;
        this.port = port;
        this.start();
    }

    private static List<DnsQuestion> newQuestions(String hostname, @Nullable ResolvedAddressTypes resolvedAddressTypes) {
        if (resolvedAddressTypes == null) {
            resolvedAddressTypes = NetUtil.isIpV4StackPreferred() ? ResolvedAddressTypes.IPV4_ONLY : ResolvedAddressTypes.IPV4_PREFERRED;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        switch (resolvedAddressTypes) {
            case IPV4_ONLY: 
            case IPV4_PREFERRED: 
            case IPV6_PREFERRED: {
                builder.add(new DefaultDnsQuestion(hostname, DnsRecordType.A));
            }
        }
        switch (resolvedAddressTypes) {
            case IPV4_PREFERRED: 
            case IPV6_PREFERRED: 
            case IPV6_ONLY: {
                builder.add(new DefaultDnsQuestion(hostname, DnsRecordType.AAAA));
            }
        }
        return builder.build();
    }

    @Override
    ImmutableSortedSet<Endpoint> onDnsRecords(List<DnsRecord> records, int ttl) throws Exception {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        boolean hasLoopbackARecords = records.stream().filter(r -> r instanceof DnsRawRecord).map(DnsRawRecord.class::cast).anyMatch(r -> r.type() == DnsRecordType.A && r.content().getByte(r.content().readerIndex()) == 127);
        for (DnsRecord r2 : records) {
            String ipAddr;
            if (!(r2 instanceof DnsRawRecord)) continue;
            DnsRecordType type = r2.type();
            ByteBuf content = ((ByteBufHolder)r2).content();
            int contentLen = content.readableBytes();
            if (type == DnsRecordType.A) {
                if (contentLen != 4) {
                    this.warnInvalidRecord(DnsRecordType.A, content);
                    continue;
                }
            } else {
                if (type != DnsRecordType.AAAA) continue;
                if (contentLen != 16) {
                    this.warnInvalidRecord(DnsRecordType.AAAA, content);
                    continue;
                }
            }
            byte[] addrBytes = new byte[contentLen];
            content.getBytes(content.readerIndex(), addrBytes);
            if (contentLen == 16) {
                if (addrBytes[0] == 0 && addrBytes[1] == 0 && addrBytes[2] == 0 && addrBytes[3] == 0 && addrBytes[4] == 0 && addrBytes[5] == 0 && addrBytes[6] == 0 && addrBytes[7] == 0 && addrBytes[8] == 0 && addrBytes[9] == 0) {
                    if (addrBytes[10] == 0 && addrBytes[11] == 0) {
                        if (addrBytes[12] == 0 && addrBytes[13] == 0 && addrBytes[14] == 0 && addrBytes[15] == 1) {
                            if (hasLoopbackARecords) continue;
                            ipAddr = "::1";
                        } else {
                            ipAddr = NetUtil.bytesToIpAddress((byte[])addrBytes, (int)12, (int)4);
                        }
                    } else {
                        ipAddr = addrBytes[10] == -1 && addrBytes[11] == -1 ? NetUtil.bytesToIpAddress((byte[])addrBytes, (int)12, (int)4) : NetUtil.bytesToIpAddress((byte[])addrBytes);
                    }
                } else {
                    ipAddr = NetUtil.bytesToIpAddress((byte[])addrBytes);
                }
            } else {
                ipAddr = NetUtil.bytesToIpAddress((byte[])addrBytes);
            }
            Endpoint endpoint = this.port != 0 ? Endpoint.of(this.hostname, this.port) : Endpoint.of(this.hostname);
            builder.add(endpoint.withIpAddr(ipAddr));
        }
        ImmutableSet endpoints = builder.build();
        if (this.logger().isDebugEnabled()) {
            this.logger().debug("{} Resolved: {} (TTL: {})", new Object[]{this.logPrefix(), endpoints.stream().map(Endpoint::ipAddr).collect(Collectors.joining(", ")), ttl});
        }
        return endpoints;
    }
}

