/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint.dns;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.DynamicEndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointGroupException;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.internal.TransportType;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSortedSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class DnsEndpointGroup
extends DynamicEndpointGroup {
    private final EventLoop eventLoop;
    private final int minTtl;
    private final int maxTtl;
    private final Backoff backoff;
    private final List<DnsQuestion> questions;
    private final DnsNameResolver resolver;
    private final Logger logger;
    private final String logPrefix;
    private boolean started;
    private volatile boolean stopped;
    @Nullable
    private volatile ScheduledFuture<?> scheduledFuture;
    int attemptsSoFar;

    DnsEndpointGroup(EventLoop eventLoop, int minTtl, int maxTtl, DnsServerAddressStreamProvider serverAddressStreamProvider, Backoff backoff, Iterable<DnsQuestion> questions, Consumer<DnsNameResolverBuilder> resolverConfigurator) {
        this.eventLoop = eventLoop;
        this.minTtl = minTtl;
        this.maxTtl = maxTtl;
        this.backoff = backoff;
        this.questions = ImmutableList.copyOf(questions);
        assert (!this.questions.isEmpty());
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.logPrefix = this.questions.stream().map(DnsRecord::name).distinct().collect(Collectors.joining(", ", "[", "]"));
        DnsNameResolverBuilder resolverBuilder = new DnsNameResolverBuilder(eventLoop).channelType(TransportType.datagramChannelType(eventLoop.parent())).ttl(minTtl, maxTtl).nameServerProvider(serverAddressStreamProvider);
        resolverConfigurator.accept(resolverBuilder);
        this.resolver = resolverBuilder.build();
    }

    final Logger logger() {
        return this.logger;
    }

    final String logPrefix() {
        return this.logPrefix;
    }

    final void start() {
        Preconditions.checkState(!this.started);
        this.started = true;
        this.eventLoop.execute(this::sendQueries);
    }

    private void sendQueries() {
        Future future;
        if (this.stopped) {
            return;
        }
        final int numQuestions = this.questions.size();
        if (numQuestions == 1) {
            DnsQuestion question = this.questions.get(0);
            this.logger.debug("{} Sending a DNS query", (Object)this.logPrefix);
            future = this.resolver.resolveAll(question);
        } else {
            this.logger.debug("{} Sending DNS queries", (Object)this.logPrefix);
            final Promise aggregatedPromise = this.eventLoop.newPromise();
            FutureListener<List<DnsRecord>> listener = new FutureListener<List<DnsRecord>>(){
                private final List<DnsRecord> records = new ArrayList<DnsRecord>();
                private int remaining = numQuestions;
                @Nullable
                private List<Throwable> causes;

                public void operationComplete(Future<List<DnsRecord>> future) throws Exception {
                    if (future.isSuccess()) {
                        List records = (List)future.getNow();
                        this.records.addAll(records);
                    } else {
                        if (this.causes == null) {
                            this.causes = new ArrayList<Throwable>(numQuestions);
                        }
                        this.causes.add(future.cause());
                    }
                    if (--this.remaining == 0) {
                        if (!this.records.isEmpty()) {
                            aggregatedPromise.setSuccess(this.records);
                        } else {
                            EndpointGroupException aggregatedCause;
                            if (this.causes == null) {
                                aggregatedCause = new EndpointGroupException("empty result returned by DNS server");
                            } else {
                                aggregatedCause = new EndpointGroupException("failed to receive DNS records");
                                for (Throwable c : this.causes) {
                                    aggregatedCause.addSuppressed(c);
                                }
                            }
                            aggregatedPromise.setFailure((Throwable)aggregatedCause);
                        }
                    }
                }
            };
            this.questions.forEach(arg_0 -> this.lambda$sendQueries$0((FutureListener)listener, arg_0));
            future = aggregatedPromise;
        }
        ++this.attemptsSoFar;
        future.addListener(this::onDnsRecords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDnsRecords(Future<? super List<DnsRecord>> future) {
        if (this.stopped) {
            if (future.isSuccess()) {
                List result = (List)future.getNow();
                result.forEach(ReferenceCountUtil::safeRelease);
            }
            return;
        }
        if (!future.isSuccess()) {
            long delayMillis = this.backoff.nextDelayMillis(this.attemptsSoFar);
            this.logger.warn("{} DNS query failed; retrying in {} ms (attempts so far: {}):", new Object[]{this.logPrefix, delayMillis, this.attemptsSoFar, future.cause()});
            this.scheduledFuture = this.eventLoop.schedule(this::sendQueries, delayMillis, TimeUnit.MILLISECONDS);
            return;
        }
        this.attemptsSoFar = 0;
        List records = (List)future.getNow();
        long serverTtl = records.stream().mapToLong(DnsRecord::timeToLive).min().orElse(this.minTtl);
        int effectiveTtl = (int)Math.max(Math.min(serverTtl, (long)this.maxTtl), (long)this.minTtl);
        try {
            this.setEndpoints(this.onDnsRecords(records, effectiveTtl));
        }
        catch (Throwable t) {
            this.logger.warn("{} Failed to process the DNS query result: {}", new Object[]{this.logPrefix, records, t});
        }
        finally {
            records.forEach(ReferenceCountUtil::safeRelease);
            this.scheduledFuture = this.eventLoop.schedule(this::sendQueries, (long)effectiveTtl, TimeUnit.SECONDS);
        }
    }

    abstract ImmutableSortedSet<Endpoint> onDnsRecords(List<DnsRecord> var1, int var2) throws Exception;

    @Override
    public final void close() {
        this.stopped = true;
        super.close();
        ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
    }

    final void warnInvalidRecord(DnsRecordType type, ByteBuf content) {
        if (this.logger().isWarnEnabled()) {
            String dump = ByteBufUtil.hexDump((ByteBuf)content);
            this.logger().warn("{} Skipping invalid {} record: {}", new Object[]{this.logPrefix(), type.name(), dump.isEmpty() ? "<empty>" : dump});
        }
    }

    private /* synthetic */ void lambda$sendQueries$0(FutureListener listener, DnsQuestion q) {
        this.resolver.resolveAll(q).addListener((GenericFutureListener)listener);
    }
}

