/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint.dns;

import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.common.CommonPools;
import com.linecorp.armeria.internal.TransportType;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.netty.channel.EventLoop;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.resolver.dns.DnsServerAddressStreamProviders;
import io.netty.resolver.dns.DnsServerAddresses;
import java.net.IDN;
import java.net.InetSocketAddress;
import java.util.Objects;
import javax.annotation.Nullable;

abstract class DnsEndpointGroupBuilder<B extends DnsEndpointGroupBuilder<B>> {
    private final String hostname;
    @Nullable
    private EventLoop eventLoop;
    private int minTtl = 1;
    private int maxTtl = Integer.MAX_VALUE;
    private DnsServerAddressStreamProvider serverAddressStreamProvider = DnsServerAddressStreamProviders.platformDefault();
    private Backoff backoff = Backoff.exponential(1000L, 32000L).withJitter(0.2);

    DnsEndpointGroupBuilder(String hostname) {
        this.hostname = Ascii.toLowerCase(IDN.toASCII(Objects.requireNonNull(hostname, "hostname"), 1));
    }

    private B self() {
        return (B)this;
    }

    final String hostname() {
        return this.hostname;
    }

    final EventLoop eventLoop() {
        if (this.eventLoop != null) {
            return this.eventLoop;
        }
        return CommonPools.workerGroup().next();
    }

    public final B eventLoop(EventLoop eventLoop) {
        Objects.requireNonNull(eventLoop, "eventLoop");
        Preconditions.checkArgument(TransportType.isSupported(eventLoop), "unsupported event loop type: %s", (Object)eventLoop);
        this.eventLoop = eventLoop;
        return this.self();
    }

    final int minTtl() {
        return this.minTtl;
    }

    final int maxTtl() {
        return this.maxTtl;
    }

    public final B ttl(int minTtl, int maxTtl) {
        Preconditions.checkArgument(minTtl > 0 && minTtl <= maxTtl, "minTtl: %s, maxTtl: %s (expected: 1 <= minTtl <= maxTtl)", minTtl, maxTtl);
        this.minTtl = minTtl;
        this.maxTtl = maxTtl;
        return this.self();
    }

    final DnsServerAddressStreamProvider serverAddressStreamProvider() {
        return this.serverAddressStreamProvider;
    }

    public final B serverAddresses(InetSocketAddress ... serverAddresses) {
        return this.serverAddresses(ImmutableList.copyOf(Objects.requireNonNull(serverAddresses, "serverAddresses")));
    }

    public final B serverAddresses(Iterable<InetSocketAddress> serverAddresses) {
        Objects.requireNonNull(serverAddresses, "serverAddresses");
        DnsServerAddresses addrs = DnsServerAddresses.sequential(serverAddresses);
        this.serverAddressStreamProvider = hostname -> addrs.stream();
        return this.self();
    }

    final Backoff backoff() {
        return this.backoff;
    }

    public final B backoff(Backoff backoff) {
        this.backoff = Objects.requireNonNull(backoff, "backoff");
        return this.self();
    }
}

