/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint.dns;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.dns.DnsEndpointGroup;
import com.linecorp.armeria.client.endpoint.dns.DnsServiceEndpointGroupBuilder;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSortedSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DefaultDnsRecordDecoder;
import io.netty.handler.codec.dns.DnsRawRecord;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import java.util.List;
import java.util.stream.Collectors;

public final class DnsServiceEndpointGroup
extends DnsEndpointGroup {
    public static DnsServiceEndpointGroup of(String hostname) {
        return new DnsServiceEndpointGroupBuilder(hostname).build();
    }

    DnsServiceEndpointGroup(EventLoop eventLoop, int minTtl, int maxTtl, DnsServerAddressStreamProvider serverAddressStreamProvider, Backoff backoff, String hostname) {
        super(eventLoop, minTtl, maxTtl, serverAddressStreamProvider, backoff, ImmutableList.of(new DefaultDnsQuestion(hostname, DnsRecordType.SRV)), unused -> {});
        this.start();
    }

    @Override
    ImmutableSortedSet<Endpoint> onDnsRecords(List<DnsRecord> records, int ttl) throws Exception {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        for (DnsRecord r : records) {
            Endpoint endpoint;
            if (!(r instanceof DnsRawRecord) || r.type() != DnsRecordType.SRV) continue;
            ByteBuf content = ((ByteBufHolder)r).content();
            if (content.readableBytes() <= 6) {
                this.warnInvalidRecord(DnsRecordType.SRV, content);
                continue;
            }
            content.markReaderIndex();
            content.skipBytes(2);
            int weight = content.readUnsignedShort();
            int port = content.readUnsignedShort();
            try {
                String target = DnsServiceEndpointGroup.stripTrailingDot(DefaultDnsRecordDecoder.decodeName((ByteBuf)content));
                endpoint = port > 0 ? Endpoint.of(target, port) : Endpoint.of(target);
            }
            catch (Exception e2) {
                content.resetReaderIndex();
                this.warnInvalidRecord(DnsRecordType.SRV, content);
                continue;
            }
            builder.add(endpoint.withWeight(weight));
        }
        ImmutableSet endpoints = builder.build();
        if (this.logger().isDebugEnabled()) {
            this.logger().debug("{} Resolved: {} (TTL: {})", new Object[]{this.logPrefix(), endpoints.stream().map(e -> e.authority() + '/' + e.weight()).collect(Collectors.joining(", ")), ttl});
        }
        return endpoints;
    }

    private static String stripTrailingDot(String name) {
        if (name.endsWith(".")) {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }
}

