/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint.dns;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.dns.DnsEndpointGroup;
import com.linecorp.armeria.client.endpoint.dns.DnsTextEndpointGroupBuilder;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSortedSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DnsRawRecord;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class DnsTextEndpointGroup
extends DnsEndpointGroup {
    private final Function<byte[], Endpoint> mapping;

    public static DnsTextEndpointGroup of(String hostname, Function<byte[], Endpoint> mapping) {
        return new DnsTextEndpointGroupBuilder(hostname, mapping).build();
    }

    DnsTextEndpointGroup(EventLoop eventLoop, int minTtl, int maxTtl, DnsServerAddressStreamProvider serverAddressStreamProvider, Backoff backoff, String hostname, Function<byte[], Endpoint> mapping) {
        super(eventLoop, minTtl, maxTtl, serverAddressStreamProvider, backoff, ImmutableList.of(new DefaultDnsQuestion(hostname, DnsRecordType.TXT)), (DnsNameResolverBuilder unused) -> {});
        this.mapping = mapping;
        this.start();
    }

    @Override
    ImmutableSortedSet<Endpoint> onDnsRecords(List<DnsRecord> records, int ttl) throws Exception {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        for (DnsRecord r : records) {
            Endpoint endpoint;
            if (!(r instanceof DnsRawRecord) || r.type() != DnsRecordType.TXT) continue;
            ByteBuf content = ((ByteBufHolder)r).content();
            if (!content.isReadable()) {
                this.warnInvalidRecord(DnsRecordType.TXT, content);
                continue;
            }
            content.markReaderIndex();
            short txtLen = content.readUnsignedByte();
            if (txtLen == 0) continue;
            if (content.readableBytes() != txtLen) {
                content.resetReaderIndex();
                this.warnInvalidRecord(DnsRecordType.TXT, content);
                continue;
            }
            byte[] txt = new byte[txtLen];
            content.readBytes(txt);
            try {
                endpoint = this.mapping.apply(txt);
            }
            catch (Exception e) {
                content.resetReaderIndex();
                this.warnInvalidRecord(DnsRecordType.TXT, content);
                continue;
            }
            if (endpoint == null) continue;
            if (endpoint.isGroup()) {
                this.logger().warn("{} Ignoring group endpoint: {}", (Object)this.logPrefix(), (Object)endpoint);
                continue;
            }
            builder.add(endpoint);
        }
        ImmutableSet endpoints = builder.build();
        if (this.logger().isDebugEnabled()) {
            this.logger().debug("{} Resolved: {} (TTL: {})", new Object[]{this.logPrefix(), endpoints.stream().map(Object::toString).collect(Collectors.joining(", ")), ttl});
        }
        return endpoints;
    }
}

