/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint.healthcheck;

import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.DynamicEndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckedEndpointGroupMetrics;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.common.util.Functions;
import com.linecorp.armeria.internal.shaded.futures.CompletableFutures;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public abstract class HealthCheckedEndpointGroup
extends DynamicEndpointGroup {
    static final Duration DEFAULT_HEALTHCHECK_RETRY_INTERVAL = Duration.ofSeconds(3L);
    private final ClientFactory clientFactory;
    private final EndpointGroup delegate;
    private final Duration retryInterval;
    volatile List<ServerConnection> allServers = ImmutableList.of();

    protected HealthCheckedEndpointGroup(ClientFactory clientFactory, EndpointGroup delegate, Duration retryInterval) {
        this.clientFactory = Objects.requireNonNull(clientFactory, "clientFactory");
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.retryInterval = Objects.requireNonNull(retryInterval, "retryInterval");
    }

    protected void init() {
        this.checkAndUpdateHealthyServers().join();
        this.scheduleCheckAndUpdateHealthyServers();
    }

    protected final ClientFactory clientFactory() {
        return this.clientFactory;
    }

    private void scheduleCheckAndUpdateHealthyServers() {
        this.clientFactory.eventLoopGroup().schedule(() -> this.checkAndUpdateHealthyServers().thenRun(this::scheduleCheckAndUpdateHealthyServers), this.retryInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    private CompletableFuture<Void> checkAndUpdateHealthyServers() {
        List<ServerConnection> checkedServers = this.updateServerList();
        CompletableFuture<List<Boolean>> healthCheckResults = CompletableFutures.successfulAsList(checkedServers.stream().map(connection -> ((ServerConnection)connection).healthChecker.isHealthy(connection.endpoint())).collect(ImmutableList.toImmutableList()), t -> false);
        return healthCheckResults.handle(Functions.voidFunction((result, thrown) -> {
            ImmutableList.Builder newHealthyEndpoints = ImmutableList.builder();
            for (int i = 0; i < result.size(); ++i) {
                if (!((Boolean)result.get(i)).booleanValue()) continue;
                newHealthyEndpoints.add(((ServerConnection)checkedServers.get(i)).endpoint());
            }
            this.setEndpoints(newHealthyEndpoints.build());
        }));
    }

    private List<ServerConnection> updateServerList() {
        Map allServersByEndpoint = this.allServers.stream().collect(ImmutableMap.toImmutableMap(ServerConnection::endpoint, Function.identity(), (l, r) -> l));
        this.allServers = this.delegate.endpoints().stream().map(endpoint -> {
            ServerConnection connection = (ServerConnection)allServersByEndpoint.get(endpoint);
            if (connection != null) {
                return connection;
            }
            return new ServerConnection((Endpoint)endpoint, this.createEndpointHealthChecker((Endpoint)endpoint));
        }).collect(ImmutableList.toImmutableList());
        return this.allServers;
    }

    protected abstract EndpointHealthChecker createEndpointHealthChecker(Endpoint var1);

    public MeterBinder newMeterBinder(String groupName) {
        return this.newMeterBinder(new MeterIdPrefix("armeria.client.endpointGroup", "name", groupName));
    }

    public MeterBinder newMeterBinder(MeterIdPrefix idPrefix) {
        return new HealthCheckedEndpointGroupMetrics(this, idPrefix);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("HealthCheckedEndpointGroup(all:[");
        for (ServerConnection connection : this.allServers) {
            buf.append(connection.endpoint).append(',');
        }
        buf.setCharAt(buf.length() - 1, ']');
        buf.append(", healthy:[");
        for (Endpoint endpoint : this.endpoints()) {
            buf.append(endpoint).append(',');
        }
        buf.setCharAt(buf.length() - 1, ']');
        buf.append(')');
        return buf.toString();
    }

    static final class ServerConnection {
        private final Endpoint endpoint;
        private final EndpointHealthChecker healthChecker;

        private ServerConnection(Endpoint endpoint, EndpointHealthChecker healthChecker) {
            this.endpoint = endpoint;
            this.healthChecker = healthChecker;
        }

        Endpoint endpoint() {
            return this.endpoint;
        }
    }

    @FunctionalInterface
    public static interface EndpointHealthChecker {
        public CompletableFuture<Boolean> isHealthy(Endpoint var1);
    }
}

