/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint.healthcheck;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckedEndpointGroup;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;

class HealthCheckedEndpointGroupMetrics
implements MeterBinder {
    private final HealthCheckedEndpointGroup endpointGroup;
    private final MeterIdPrefix idPrefix;

    HealthCheckedEndpointGroupMetrics(HealthCheckedEndpointGroup endpointGroup, MeterIdPrefix idPrefix) {
        this.endpointGroup = Objects.requireNonNull(endpointGroup, "endpointGroup");
        this.idPrefix = Objects.requireNonNull(idPrefix, "idPrefix");
    }

    public void bindTo(MeterRegistry registry) {
        String count = this.idPrefix.name("count");
        registry.gauge(count, this.idPrefix.tags("state", "healthy"), (Object)this.endpointGroup, unused -> this.endpointGroup.endpoints().size());
        registry.gauge(count, this.idPrefix.tags("state", "unhealthy"), (Object)this.endpointGroup, unused -> this.endpointGroup.allServers.size() - this.endpointGroup.endpoints().size());
        ListenerImpl listener = new ListenerImpl(registry, this.idPrefix.append("healthy"));
        listener.accept(this.endpointGroup.endpoints());
        this.endpointGroup.addListener(listener);
    }

    private final class ListenerImpl
    implements Consumer<List<Endpoint>> {
        private final MeterRegistry registry;
        private final MeterIdPrefix idPrefix;
        private final ConcurrentMap<Endpoint, Boolean> healthMap = new ConcurrentHashMap<Endpoint, Boolean>();

        ListenerImpl(MeterRegistry registry, MeterIdPrefix idPrefix) {
            this.registry = registry;
            this.idPrefix = idPrefix;
        }

        @Override
        public void accept(List<Endpoint> endpoints) {
            HashMap<Endpoint, Boolean> endpointsToUpdate = new HashMap<Endpoint, Boolean>();
            endpoints.forEach(e -> endpointsToUpdate.put((Endpoint)e, true));
            ((HealthCheckedEndpointGroupMetrics)HealthCheckedEndpointGroupMetrics.this).endpointGroup.allServers.forEach(conn -> endpointsToUpdate.putIfAbsent(conn.endpoint(), false));
            this.healthMap.entrySet().forEach(e -> {
                Endpoint authority = (Endpoint)e.getKey();
                Boolean healthy = (Boolean)endpointsToUpdate.remove(authority);
                e.setValue(Boolean.TRUE.equals(healthy));
            });
            endpointsToUpdate.forEach((endpoint, healthy) -> {
                this.healthMap.put((Endpoint)endpoint, (Boolean)healthy);
                ArrayList<Tag> tags = new ArrayList<Tag>(2);
                tags.add(Tag.of((String)"authority", (String)endpoint.authority()));
                if (endpoint.hasIpAddr()) {
                    String address = endpoint.ipAddr();
                    assert (address != null);
                    tags.add(Tag.of((String)"ip", (String)address));
                }
                this.registry.gauge(this.idPrefix.name(), this.idPrefix.tags(tags), (Object)this, unused -> (Boolean)this.healthMap.get(endpoint) != false ? 1.0 : 0.0);
            });
        }
    }
}

