/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint.healthcheck;

import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOptionsBuilder;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.HttpClientBuilder;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckedEndpointGroup;
import com.linecorp.armeria.client.endpoint.healthcheck.HttpHealthCheckedEndpointGroupBuilder;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.SessionProtocol;
import java.net.StandardProtocolFamily;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class HttpHealthCheckedEndpointGroup
extends HealthCheckedEndpointGroup {
    private final SessionProtocol protocol;
    private final String healthCheckPath;
    private final Function<? super ClientOptionsBuilder, ClientOptionsBuilder> configurator;

    public static HttpHealthCheckedEndpointGroup of(EndpointGroup delegate, String healthCheckPath) {
        return new HttpHealthCheckedEndpointGroupBuilder(delegate, healthCheckPath).build();
    }

    @Deprecated
    public static HttpHealthCheckedEndpointGroup of(EndpointGroup delegate, String healthCheckPath, Duration healthCheckRetryInterval) {
        return HttpHealthCheckedEndpointGroup.of(ClientFactory.DEFAULT, delegate, healthCheckPath, healthCheckRetryInterval);
    }

    @Deprecated
    public static HttpHealthCheckedEndpointGroup of(ClientFactory clientFactory, EndpointGroup delegate, String healthCheckPath, Duration healthCheckRetryInterval) {
        return new HttpHealthCheckedEndpointGroupBuilder(delegate, healthCheckPath).clientFactory(clientFactory).retryInterval(healthCheckRetryInterval).build();
    }

    HttpHealthCheckedEndpointGroup(ClientFactory clientFactory, EndpointGroup delegate, SessionProtocol protocol, String healthCheckPath, Duration healthCheckRetryInterval, Function<? super ClientOptionsBuilder, ClientOptionsBuilder> configurator) {
        super(clientFactory, delegate, healthCheckRetryInterval);
        this.protocol = Objects.requireNonNull(protocol, "protocol");
        this.healthCheckPath = Objects.requireNonNull(healthCheckPath, "healthCheckPath");
        this.configurator = Objects.requireNonNull(configurator, "configurator");
        this.init();
    }

    @Override
    protected HealthCheckedEndpointGroup.EndpointHealthChecker createEndpointHealthChecker(Endpoint endpoint) {
        return new HttpEndpointHealthChecker(this.clientFactory(), endpoint, this.protocol, this.healthCheckPath, this.configurator);
    }

    private static final class HttpEndpointHealthChecker
    implements HealthCheckedEndpointGroup.EndpointHealthChecker {
        private final HttpClient httpClient;
        private final String healthCheckPath;

        private HttpEndpointHealthChecker(ClientFactory clientFactory, Endpoint endpoint, SessionProtocol protocol, String healthCheckPath, Function<? super ClientOptionsBuilder, ClientOptionsBuilder> configurator) {
            HttpClientBuilder builder;
            String scheme = protocol.uriText();
            String ipAddr = endpoint.ipAddr();
            if (ipAddr == null) {
                builder = new HttpClientBuilder(scheme + "://" + endpoint.authority());
            } else {
                int port = endpoint.port(protocol.defaultPort());
                builder = endpoint.ipFamily() == StandardProtocolFamily.INET ? new HttpClientBuilder(scheme + "://" + ipAddr + ':' + port) : new HttpClientBuilder(scheme + "://[" + ipAddr + "]:" + port);
                builder.setHttpHeader(HttpHeaderNames.AUTHORITY, endpoint.authority());
            }
            this.httpClient = ((HttpClientBuilder)builder.factory(clientFactory).options(configurator.apply(new ClientOptionsBuilder()).build())).build();
            this.healthCheckPath = healthCheckPath;
        }

        @Override
        public CompletableFuture<Boolean> isHealthy(Endpoint endpoint) {
            return this.httpClient.get(this.healthCheckPath).aggregate().thenApply(message -> HttpStatus.OK.equals(message.status()));
        }
    }
}

