/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint.healthcheck;

import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOptionsBuilder;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckedEndpointGroup;
import com.linecorp.armeria.client.endpoint.healthcheck.HttpHealthCheckedEndpointGroup;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;

public class HttpHealthCheckedEndpointGroupBuilder {
    private final EndpointGroup delegate;
    private final String healthCheckPath;
    private SessionProtocol protocol = SessionProtocol.HTTP;
    private Duration retryInterval = HealthCheckedEndpointGroup.DEFAULT_HEALTHCHECK_RETRY_INTERVAL;
    private ClientFactory clientFactory = ClientFactory.DEFAULT;
    private Function<? super ClientOptionsBuilder, ClientOptionsBuilder> configurator = Function.identity();

    public HttpHealthCheckedEndpointGroupBuilder(EndpointGroup delegate, String healthCheckPath) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.healthCheckPath = Objects.requireNonNull(healthCheckPath, "healthCheckPath");
    }

    public HttpHealthCheckedEndpointGroupBuilder protocol(SessionProtocol protocol) {
        this.protocol = Objects.requireNonNull(protocol, "protocol");
        return this;
    }

    public HttpHealthCheckedEndpointGroupBuilder retryInterval(Duration retryInterval) {
        Objects.requireNonNull(retryInterval, "retryInterval");
        Preconditions.checkArgument(!retryInterval.isNegative() && !retryInterval.isZero(), "retryInterval: %s (expected > 0)", (Object)retryInterval);
        this.retryInterval = retryInterval;
        return this;
    }

    public HttpHealthCheckedEndpointGroupBuilder clientFactory(ClientFactory clientFactory) {
        this.clientFactory = Objects.requireNonNull(clientFactory, "clientFactory");
        return this;
    }

    public HttpHealthCheckedEndpointGroupBuilder withClientOptions(Function<? super ClientOptionsBuilder, ClientOptionsBuilder> configurator) {
        this.configurator = Objects.requireNonNull(configurator, "configurator");
        return this;
    }

    public HttpHealthCheckedEndpointGroup build() {
        return new HttpHealthCheckedEndpointGroup(this.clientFactory, this.delegate, this.protocol, this.healthCheckPath, this.retryInterval, this.configurator);
    }
}

