/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.limit;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.ResponseTimeoutException;
import com.linecorp.armeria.client.SimpleDecoratingClient;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.common.util.SafeCloseable;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public abstract class ConcurrencyLimitingClient<I extends Request, O extends Response>
extends SimpleDecoratingClient<I, O> {
    private static final long DEFAULT_TIMEOUT_MILLIS = 10000L;
    private final int maxConcurrency;
    private final long timeoutMillis;
    private final AtomicInteger numActiveRequests = new AtomicInteger();
    private final Queue<PendingTask> pendingRequests = new ConcurrentLinkedQueue<PendingTask>();

    protected ConcurrencyLimitingClient(Client<I, O> delegate, int maxConcurrency) {
        this(delegate, maxConcurrency, 10000L, TimeUnit.MILLISECONDS);
    }

    protected ConcurrencyLimitingClient(Client<I, O> delegate, int maxConcurrency, long timeout, TimeUnit unit) {
        super(delegate);
        ConcurrencyLimitingClient.validateAll(maxConcurrency, timeout, unit);
        this.maxConcurrency = maxConcurrency;
        this.timeoutMillis = unit.toMillis(timeout);
    }

    static void validateAll(int maxConcurrency, long timeout, TimeUnit unit) {
        ConcurrencyLimitingClient.validateMaxConcurrency(maxConcurrency);
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout: " + timeout + " (expected: >= 0)");
        }
        Objects.requireNonNull(unit, "unit");
    }

    static void validateMaxConcurrency(int maxConcurrency) {
        if (maxConcurrency < 0) {
            throw new IllegalArgumentException("maxConcurrency: " + maxConcurrency + " (expected: >= 0)");
        }
    }

    public int numActiveRequests() {
        return this.numActiveRequests.get();
    }

    @Override
    public O execute(ClientRequestContext ctx, I req) throws Exception {
        return this.maxConcurrency == 0 ? this.unlimitedExecute(ctx, req) : this.limitedExecute(ctx, req);
    }

    private O limitedExecute(ClientRequestContext ctx, I req) throws Exception {
        Deferred deferred = this.defer(ctx, req);
        PendingTask currentTask = new PendingTask(this, ctx, req, deferred);
        this.pendingRequests.add(currentTask);
        this.drain();
        if (!currentTask.isRun() && this.timeoutMillis != 0L) {
            ScheduledFuture timeoutFuture = ctx.eventLoop().schedule(() -> deferred.close(ResponseTimeoutException.get()), this.timeoutMillis, TimeUnit.MILLISECONDS);
            currentTask.set(timeoutFuture);
        }
        return deferred.response();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private O unlimitedExecute(ClientRequestContext ctx, I req) throws Exception {
        this.numActiveRequests.incrementAndGet();
        boolean success = false;
        try {
            Object res = this.delegate().execute(ctx, req);
            res.completionFuture().whenComplete((unused, cause) -> this.numActiveRequests.decrementAndGet());
            success = true;
            Object o = res;
            return o;
        }
        finally {
            if (!success) {
                this.numActiveRequests.decrementAndGet();
            }
        }
    }

    void drain() {
        int currentActiveRequests;
        while (!this.pendingRequests.isEmpty() && (currentActiveRequests = this.numActiveRequests.get()) < this.maxConcurrency) {
            if (!this.numActiveRequests.compareAndSet(currentActiveRequests, currentActiveRequests + 1)) continue;
            PendingTask task = this.pendingRequests.poll();
            if (task == null) {
                this.numActiveRequests.decrementAndGet();
                if (this.pendingRequests.isEmpty()) break;
                continue;
            }
            task.run();
        }
    }

    protected abstract Deferred<O> defer(ClientRequestContext var1, I var2) throws Exception;

    private static final class PendingTask
    extends AtomicReference<ScheduledFuture<?>>
    implements Runnable {
        private static final long serialVersionUID = -7092037489640350376L;
        private final ClientRequestContext ctx;
        private final I req;
        private final Deferred<O> deferred;
        private boolean isRun;
        final /* synthetic */ ConcurrencyLimitingClient this$0;

        PendingTask(ClientRequestContext ctx, I req, Deferred<O> deferred) {
            this.this$0 = var1_1;
            this.ctx = ctx;
            this.req = req;
            this.deferred = deferred;
        }

        boolean isRun() {
            return this.isRun;
        }

        @Override
        public void run() {
            this.isRun = true;
            ScheduledFuture timeoutFuture = (ScheduledFuture)this.get();
            if (timeoutFuture != null && (timeoutFuture.isDone() || !timeoutFuture.cancel(false))) {
                this.this$0.numActiveRequests.decrementAndGet();
                return;
            }
            try (SafeCloseable ignored = this.ctx.push();){
                try {
                    Object actualRes = this.this$0.delegate().execute(this.ctx, this.req);
                    actualRes.completionFuture().whenCompleteAsync((unused, cause) -> {
                        this.this$0.numActiveRequests.decrementAndGet();
                        this.this$0.drain();
                    }, (Executor)this.ctx.eventLoop());
                    this.deferred.delegate(actualRes);
                }
                catch (Throwable t) {
                    this.this$0.numActiveRequests.decrementAndGet();
                    this.deferred.close(t);
                }
            }
        }
    }

    public static interface Deferred<O extends Response> {
        public O response();

        public void delegate(O var1);

        public void close(Throwable var1);
    }
}

