/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.limit;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.limit.ConcurrencyLimitingClient;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public final class ConcurrencyLimitingHttpClient
extends ConcurrencyLimitingClient<HttpRequest, HttpResponse> {
    public static Function<Client<HttpRequest, HttpResponse>, ConcurrencyLimitingHttpClient> newDecorator(int maxConcurrency) {
        ConcurrencyLimitingHttpClient.validateMaxConcurrency(maxConcurrency);
        return delegate -> new ConcurrencyLimitingHttpClient((Client<HttpRequest, HttpResponse>)delegate, maxConcurrency);
    }

    public static Function<Client<HttpRequest, HttpResponse>, ConcurrencyLimitingHttpClient> newDecorator(int maxConcurrency, long timeout, TimeUnit unit) {
        ConcurrencyLimitingHttpClient.validateAll(maxConcurrency, timeout, unit);
        return delegate -> new ConcurrencyLimitingHttpClient((Client<HttpRequest, HttpResponse>)delegate, maxConcurrency, timeout, unit);
    }

    private ConcurrencyLimitingHttpClient(Client<HttpRequest, HttpResponse> delegate, int maxConcurrency) {
        super(delegate, maxConcurrency);
    }

    private ConcurrencyLimitingHttpClient(Client<HttpRequest, HttpResponse> delegate, int maxConcurrency, long timeout, TimeUnit unit) {
        super(delegate, maxConcurrency, timeout, unit);
    }

    @Override
    protected ConcurrencyLimitingClient.Deferred<HttpResponse> defer(ClientRequestContext ctx, HttpRequest req) throws Exception {
        return new ConcurrencyLimitingClient.Deferred<HttpResponse>(){
            private final CompletableFuture<HttpResponse> responseFuture = new CompletableFuture();
            private final HttpResponse res = HttpResponse.from(this.responseFuture);

            @Override
            public HttpResponse response() {
                return this.res;
            }

            @Override
            public void delegate(HttpResponse response) {
                this.responseFuture.complete(response);
            }

            @Override
            public void close(Throwable cause) {
                this.responseFuture.completeExceptionally(cause);
            }
        };
    }
}

