/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.logging;

import com.linecorp.armeria.client.pool.KeyedChannelPoolHandler;
import com.linecorp.armeria.client.pool.PoolKey;
import com.linecorp.armeria.common.util.TextFormatter;
import com.linecorp.armeria.common.util.Ticker;
import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyedChannelPoolLoggingHandler
implements KeyedChannelPoolHandler<PoolKey> {
    private static final Logger logger = LoggerFactory.getLogger(KeyedChannelPoolLoggingHandler.class);
    private static final AttributeKey<ChannelStat> STAT = AttributeKey.valueOf(KeyedChannelPoolLoggingHandler.class, (String)"STAT");
    private final AtomicInteger activeChannels = new AtomicInteger();
    private final Ticker ticker;

    public KeyedChannelPoolLoggingHandler() {
        this(Ticker.systemTicker());
    }

    public KeyedChannelPoolLoggingHandler(Ticker ticker) {
        this.ticker = Objects.requireNonNull(ticker, "ticker");
    }

    @Override
    public void channelReleased(PoolKey key, Channel ch) throws Exception {
        this.logInfo(key, ch, EventType.RELEASED);
    }

    @Override
    public void channelAcquired(PoolKey key, Channel ch) throws Exception {
        this.logInfo(key, ch, EventType.ACQUIRED);
    }

    @Override
    public void channelCreated(PoolKey key, Channel ch) throws Exception {
        this.logInfo(key, ch, EventType.CREATED);
    }

    @Override
    public void channelClosed(PoolKey key, Channel ch) throws Exception {
        this.logInfo(key, ch, EventType.CLOSED);
    }

    private void logInfo(PoolKey key, Channel ch, EventType eventType) {
        if (logger.isInfoEnabled()) {
            logger.info("{} {} {} ({})", new Object[]{ch, eventType.actionDescription(), key, this.status(ch, eventType)});
        }
    }

    private StringBuilder status(Channel ch, EventType event) {
        ChannelStat state;
        if (event == EventType.CREATED) {
            state = new ChannelStat(this.ticker);
            ch.attr(STAT).set((Object)state);
        } else {
            state = (ChannelStat)ch.attr(STAT).get();
        }
        StringBuilder buf = new StringBuilder(16);
        if (state != null) {
            state.collectAndStatus(event, buf);
            this.activeChannelStatus(event, buf);
        }
        return buf;
    }

    private void activeChannelStatus(EventType event, StringBuilder buf) {
        switch (event) {
            case CREATED: {
                this.activeChannels.incrementAndGet();
                break;
            }
            case CLOSED: {
                this.activeChannels.decrementAndGet();
            }
            default: {
                buf.append(", ");
            }
        }
        buf.append("active channels: ").append(this.activeChannels.get());
    }

    private static class ChannelStat
    extends AtomicInteger {
        private static final long serialVersionUID = -851703990840809289L;
        private final Ticker ticker;
        private final long createdNanos;
        private long lastUsedNanos;

        ChannelStat(Ticker ticker) {
            this.createdNanos = ticker.read();
            this.ticker = ticker;
        }

        void collect(EventType eventType) {
            switch (eventType) {
                case ACQUIRED: {
                    this.incrementAndGet();
                }
                case RELEASED: {
                    this.lastUsedNanos = System.nanoTime();
                }
            }
        }

        StringBuilder status(EventType eventType, StringBuilder buf) {
            long currentNanos = this.ticker.read();
            switch (eventType) {
                case ACQUIRED: {
                    buf.append("was idle for ");
                    TextFormatter.appendElapsed(buf, this.lastUsedNanos, currentNanos);
                    buf.append(", ");
                }
                case RELEASED: 
                case CLOSED: {
                    buf.append("used ").append(this.get()).append(" time(s), ");
                    TextFormatter.appendElapsed(buf, this.createdNanos, currentNanos);
                    buf.append(" old");
                }
            }
            return buf;
        }

        StringBuilder collectAndStatus(EventType eventType, StringBuilder buf) {
            this.collect(eventType);
            return this.status(eventType, buf);
        }
    }

    private static enum EventType {
        CREATED("Created on"),
        ACQUIRED("Acquired from"),
        RELEASED("Released from"),
        CLOSED("Closed on");

        private final String actionDescription;

        private EventType(String actionDescription) {
            this.actionDescription = actionDescription;
        }

        String actionDescription() {
            return this.actionDescription;
        }
    }
}

