/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.logging;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.SimpleDecoratingClient;
import com.linecorp.armeria.client.logging.LoggingClientBuilder;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.common.logging.LogLevel;
import com.linecorp.armeria.common.logging.RequestLogAvailability;
import com.linecorp.armeria.internal.logging.LoggingDecorators;
import com.linecorp.armeria.internal.logging.Sampler;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoggingClient<I extends Request, O extends Response>
extends SimpleDecoratingClient<I, O> {
    private static final Logger logger = LoggerFactory.getLogger(LoggingClient.class);
    private static final String REQUEST_FORMAT = "{} Request: {}";
    private static final String RESPONSE_FORMAT = "{} Response: {}";
    private final LogLevel requestLogLevel;
    private final LogLevel successfulResponseLogLevel;
    private final LogLevel failedResponseLogLevel;
    private final Function<HttpHeaders, HttpHeaders> requestHeadersSanitizer;
    private final Function<Object, Object> requestContentSanitizer;
    private final Function<HttpHeaders, HttpHeaders> responseHeadersSanitizer;
    private final Function<Object, Object> responseContentSanitizer;
    private final Sampler sampler;

    public static <I extends Request, O extends Response> Function<Client<I, O>, LoggingClient<I, O>> newDecorator() {
        return ((LoggingClientBuilder)((LoggingClientBuilder)((LoggingClientBuilder)new LoggingClientBuilder().requestLogLevel(LogLevel.INFO)).successfulResponseLogLevel(LogLevel.INFO)).failureResponseLogLevel(LogLevel.WARN)).newDecorator();
    }

    @Deprecated
    public static <I extends Request, O extends Response> Function<Client<I, O>, LoggingClient<I, O>> newDecorator(LogLevel level) {
        return delegate -> new LoggingClient(delegate, level);
    }

    @Deprecated
    public LoggingClient(Client<I, O> delegate) {
        this(delegate, LogLevel.INFO);
    }

    @Deprecated
    public LoggingClient(Client<I, O> delegate, LogLevel level) {
        this(delegate, level, level, level, Function.identity(), Function.identity(), Function.identity(), Function.identity(), Sampler.always());
    }

    LoggingClient(Client<I, O> delegate, LogLevel requestLogLevel, LogLevel successfulResponseLogLevel, LogLevel failedResponseLogLevel, Function<HttpHeaders, HttpHeaders> requestHeadersSanitizer, Function<Object, Object> requestContentSanitizer, Function<HttpHeaders, HttpHeaders> responseHeadersSanitizer, Function<Object, Object> responseContentSanitizer, Sampler sampler) {
        super(Objects.requireNonNull(delegate, "delegate"));
        this.requestLogLevel = Objects.requireNonNull(requestLogLevel, "requestLogLevel");
        this.successfulResponseLogLevel = Objects.requireNonNull(successfulResponseLogLevel, "successfulResponseLogLevel");
        this.failedResponseLogLevel = Objects.requireNonNull(failedResponseLogLevel, "failedResponseLogLevel");
        this.requestHeadersSanitizer = Objects.requireNonNull(requestHeadersSanitizer, "requestHeadersSanitizer");
        this.requestContentSanitizer = Objects.requireNonNull(requestContentSanitizer, "requestContentSanitizer");
        this.responseHeadersSanitizer = Objects.requireNonNull(responseHeadersSanitizer, "responseHeadersSanitizer");
        this.responseContentSanitizer = Objects.requireNonNull(responseContentSanitizer, "resposneContentSanitizer");
        this.sampler = Objects.requireNonNull(sampler, "sampler");
    }

    @Override
    public O execute(ClientRequestContext ctx, I req) throws Exception {
        if (this.sampler.isSampled()) {
            ctx.log().addListener(log -> LoggingDecorators.logRequest(logger, log, this.requestLogLevel, this.requestHeadersSanitizer, this.requestContentSanitizer), RequestLogAvailability.REQUEST_END);
            ctx.log().addListener(log -> LoggingDecorators.logResponse(logger, log, this.requestLogLevel, this.requestHeadersSanitizer, this.requestContentSanitizer, this.successfulResponseLogLevel, this.failedResponseLogLevel, this.responseHeadersSanitizer, this.responseContentSanitizer), RequestLogAvailability.COMPLETE);
        }
        return this.delegate().execute(ctx, req);
    }
}

