/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.pool;

import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.Objects;

public final class PoolKey {
    private final String host;
    private final String ipAddr;
    private final int port;
    private final SessionProtocol sessionProtocol;

    public PoolKey(String host, String ipAddr, int port, SessionProtocol sessionProtocol) {
        this.host = Objects.requireNonNull(host, "host");
        this.ipAddr = Objects.requireNonNull(ipAddr, "ipAddr");
        this.port = port;
        this.sessionProtocol = Objects.requireNonNull(sessionProtocol, "sessionProtocol");
    }

    public String host() {
        return this.host;
    }

    public String ipAddr() {
        return this.ipAddr;
    }

    public int port() {
        return this.port;
    }

    public SessionProtocol sessionProtocol() {
        return this.sessionProtocol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PoolKey)) {
            return false;
        }
        PoolKey that = (PoolKey)o;
        return this.host.equals(that.host) && this.ipAddr.equals(that.ipAddr) && this.port == that.port && this.sessionProtocol == that.sessionProtocol;
    }

    public int hashCode() {
        return ((this.host.hashCode() * 31 + this.ipAddr.hashCode()) * 31 + this.port) * 31 + this.sessionProtocol.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sessionProtocol", this.sessionProtocol.uriText()).add("host", this.host).add("ipAddr", this.ipAddr).add("port", this.port).toString();
    }
}

