/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.pool;

import com.linecorp.armeria.client.pool.KeyedChannelPoolHandler;
import io.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SafeKeyedChannelPoolHandler<K>
implements KeyedChannelPoolHandler<K> {
    private static final Logger logger = LoggerFactory.getLogger(SafeKeyedChannelPoolHandler.class);
    private final KeyedChannelPoolHandler<K> handler;

    SafeKeyedChannelPoolHandler(KeyedChannelPoolHandler<K> handler) {
        this.handler = handler;
    }

    private static void logFailure(String handlerName, Throwable cause) {
        logger.warn("Exception handling {}()", (Object)handlerName, (Object)cause);
    }

    @Override
    public void channelReleased(K key, Channel ch) {
        try {
            this.handler.channelReleased(key, ch);
        }
        catch (Exception e) {
            SafeKeyedChannelPoolHandler.logFailure("channelReleased", e);
        }
    }

    @Override
    public void channelAcquired(K key, Channel ch) {
        try {
            this.handler.channelAcquired(key, ch);
        }
        catch (Exception e) {
            SafeKeyedChannelPoolHandler.logFailure("channelAcquired", e);
        }
    }

    @Override
    public void channelCreated(K key, Channel ch) {
        try {
            this.handler.channelCreated(key, ch);
        }
        catch (Exception e) {
            SafeKeyedChannelPoolHandler.logFailure("channelCreated", e);
        }
    }

    @Override
    public void channelClosed(K key, Channel ch) {
        try {
            this.handler.channelClosed(key, ch);
        }
        catch (Exception e) {
            SafeKeyedChannelPoolHandler.logFailure("channelClosed", e);
        }
    }
}

