/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.retry;

import com.linecorp.armeria.client.retry.AttemptLimitingBackoff;
import com.linecorp.armeria.client.retry.BackoffSpec;
import com.linecorp.armeria.client.retry.ExponentialBackoff;
import com.linecorp.armeria.client.retry.FixedBackoff;
import com.linecorp.armeria.client.retry.JitterAddingBackoff;
import com.linecorp.armeria.client.retry.RandomBackoff;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;

@FunctionalInterface
public interface Backoff {
    public static Backoff withoutDelay() {
        return FixedBackoff.NO_DELAY;
    }

    public static Backoff fixed(long delayMillis) {
        return new FixedBackoff(delayMillis);
    }

    public static Backoff exponential(long initialDelayMillis, long maxDelayMillis) {
        return Backoff.exponential(initialDelayMillis, maxDelayMillis, 2.0);
    }

    public static Backoff exponential(long initialDelayMillis, long maxDelayMillis, double multiplier) {
        return new ExponentialBackoff(initialDelayMillis, maxDelayMillis, multiplier);
    }

    public static Backoff random(long minDelayMillis, long maxDelayMillis) {
        return Backoff.random(minDelayMillis, maxDelayMillis, ThreadLocalRandom::current);
    }

    public static Backoff random(long minDelayMillis, long maxDelayMillis, Supplier<Random> randomSupplier) {
        return new RandomBackoff(minDelayMillis, maxDelayMillis, randomSupplier);
    }

    public static Backoff of(String specification) {
        return BackoffSpec.parse(specification).build();
    }

    public long nextDelayMillis(int var1);

    default public <T> Optional<T> as(Class<T> backoffType) {
        Objects.requireNonNull(backoffType, "backoffType");
        return backoffType.isInstance(this) ? Optional.of(backoffType.cast(this)) : Optional.empty();
    }

    default public Backoff withJitter(double jitterRate) {
        Preconditions.checkArgument(0.0 <= jitterRate && jitterRate <= 1.0, "jitterRate: %s (expected: >= 0.0 and <= 1.0)", (Object)jitterRate);
        return this.withJitter(-jitterRate, jitterRate, ThreadLocalRandom::current);
    }

    default public Backoff withJitter(double minJitterRate, double maxJitterRate) {
        return this.withJitter(minJitterRate, maxJitterRate, ThreadLocalRandom::current);
    }

    default public Backoff withJitter(double minJitterRate, double maxJitterRate, Supplier<Random> randomSupplier) {
        return new JitterAddingBackoff(this, minJitterRate, maxJitterRate, randomSupplier);
    }

    default public Backoff withMaxAttempts(int maxAttempts) {
        return new AttemptLimitingBackoff(this, maxAttempts);
    }
}

