/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.retry;

import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.client.retry.RetryStrategy;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.internal.HttpHeaderSubscriber;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

final class HttpStatusBasedRetryStrategy
implements RetryStrategy<HttpRequest, HttpResponse> {
    private final BiFunction<HttpStatus, Throwable, Backoff> backoffFunction;

    HttpStatusBasedRetryStrategy(BiFunction<HttpStatus, Throwable, Backoff> backoffFunction) {
        this.backoffFunction = Objects.requireNonNull(backoffFunction, "backoffFunction");
    }

    @Override
    public CompletionStage<Backoff> shouldRetry(HttpRequest request, HttpResponse response) {
        CompletableFuture<HttpHeaders> future = new CompletableFuture<HttpHeaders>();
        HttpHeaderSubscriber subscriber = new HttpHeaderSubscriber(future);
        response.completionFuture().whenComplete((BiConsumer)subscriber);
        response.subscribe(subscriber);
        return future.handle((headers, thrown) -> this.backoffFunction.apply(headers != null ? headers.status() : null, (Throwable)thrown));
    }
}

