/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.retry;

import com.linecorp.armeria.client.UnprocessedRequestException;
import com.linecorp.armeria.client.circuitbreaker.FailFastException;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.client.retry.HttpStatusBasedRetryStrategy;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.HttpStatusClass;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.common.util.Exceptions;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;

@FunctionalInterface
public interface RetryStrategy<I extends Request, O extends Response> {
    public static final Backoff defaultBackoff = Backoff.of(Flags.defaultBackoffSpec());

    public static <I extends Request, O extends Response> RetryStrategy<I, O> never() {
        return (request, response) -> CompletableFuture.completedFuture(null);
    }

    public static RetryStrategy<HttpRequest, HttpResponse> onUnprocessed() {
        return RetryStrategy.onUnprocessed(defaultBackoff);
    }

    public static RetryStrategy<HttpRequest, HttpResponse> onUnprocessed(Backoff backoff) {
        Objects.requireNonNull(backoff, "backoff");
        return RetryStrategy.onStatus((status, thrown) -> {
            if (thrown != null && Exceptions.peel(thrown) instanceof UnprocessedRequestException) {
                return backoff;
            }
            return null;
        });
    }

    public static RetryStrategy<HttpRequest, HttpResponse> onServerErrorStatus() {
        return RetryStrategy.onServerErrorStatus(defaultBackoff);
    }

    public static RetryStrategy<HttpRequest, HttpResponse> onServerErrorStatus(Backoff backoff) {
        Objects.requireNonNull(backoff, "backoff");
        return RetryStrategy.onStatus((status, thrown) -> {
            if (thrown != null && !(Exceptions.peel(thrown) instanceof FailFastException) || status != null && status.codeClass() == HttpStatusClass.SERVER_ERROR) {
                return backoff;
            }
            return null;
        });
    }

    public static RetryStrategy<HttpRequest, HttpResponse> onStatus(BiFunction<HttpStatus, Throwable, Backoff> backoffFunction) {
        return new HttpStatusBasedRetryStrategy(backoffFunction);
    }

    public CompletionStage<Backoff> shouldRetry(I var1, O var2);
}

