/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.retry;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.ClosedClientFactoryException;
import com.linecorp.armeria.client.SimpleDecoratingClient;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.client.retry.RetryStrategy;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RetryingClient<I extends Request, O extends Response>
extends SimpleDecoratingClient<I, O> {
    private static final Logger logger = LoggerFactory.getLogger(RetryingClient.class);
    private static final AttributeKey<State> STATE = AttributeKey.valueOf(RetryingClient.class, (String)"STATE");
    private final RetryStrategy<I, O> retryStrategy;
    private final int maxTotalAttempts;
    private final long responseTimeoutMillisForEachAttempt;

    protected RetryingClient(Client<I, O> delegate, RetryStrategy<I, O> retryStrategy, int maxTotalAttempts, long responseTimeoutMillisForEachAttempt) {
        super(delegate);
        this.retryStrategy = Objects.requireNonNull(retryStrategy, "retryStrategy");
        Preconditions.checkArgument(maxTotalAttempts > 0, "maxTotalAttempts: %s (expected: > 0)", maxTotalAttempts);
        this.maxTotalAttempts = maxTotalAttempts;
        Preconditions.checkArgument(responseTimeoutMillisForEachAttempt >= 0L, "responseTimeoutMillisForEachAttempt: %s (expected: >= 0)", responseTimeoutMillisForEachAttempt);
        this.responseTimeoutMillisForEachAttempt = responseTimeoutMillisForEachAttempt;
    }

    @Override
    public O execute(ClientRequestContext ctx, I req) throws Exception {
        State state = new State(this.maxTotalAttempts, this.responseTimeoutMillisForEachAttempt, ctx.responseTimeoutMillis());
        ctx.attr(STATE).set((Object)state);
        return this.doExecute(ctx, req);
    }

    protected abstract O doExecute(ClientRequestContext var1, I var2) throws Exception;

    protected final O executeDelegate(ClientRequestContext ctx, I req) throws Exception {
        ClientRequestContext derivedContext = ctx.newDerivedContext((Request)req);
        ctx.logBuilder().addChild(derivedContext.log());
        try (SafeCloseable ignore = derivedContext.push(false);){
            Object o = this.delegate().execute(derivedContext, req);
            return o;
        }
    }

    protected static void onRetryingComplete(ClientRequestContext ctx) {
        ctx.logBuilder().endResponseWithLastChild();
    }

    protected RetryStrategy<I, O> retryStrategy() {
        return this.retryStrategy;
    }

    protected static void scheduleNextRetry(ClientRequestContext ctx, Consumer<? super Throwable> actionOnException, Runnable retryTask, long nextDelayMillis) {
        try {
            if (nextDelayMillis == 0L) {
                ctx.contextAwareEventLoop().execute(retryTask);
            } else {
                ScheduledFuture scheduledFuture = ctx.contextAwareEventLoop().schedule(retryTask, nextDelayMillis, TimeUnit.MILLISECONDS);
                scheduledFuture.addListener(future -> {
                    if (future.isCancelled()) {
                        actionOnException.accept(ClosedClientFactoryException.get());
                    }
                });
            }
        }
        catch (Throwable t) {
            actionOnException.accept(t);
        }
    }

    protected final boolean setResponseTimeout(ClientRequestContext ctx) {
        Objects.requireNonNull(ctx, "ctx");
        long responseTimeoutMillis = ((State)ctx.attr(STATE).get()).responseTimeoutMillis();
        if (responseTimeoutMillis < 0L) {
            return false;
        }
        ctx.setResponseTimeoutMillis(responseTimeoutMillis);
        return true;
    }

    protected final long getNextDelay(ClientRequestContext ctx, Backoff backoff) {
        return this.getNextDelay(ctx, backoff, -1L);
    }

    protected final long getNextDelay(ClientRequestContext ctx, Backoff backoff, long millisAfterFromServer) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(backoff, "backoff");
        State state = (State)ctx.attr(STATE).get();
        int currentAttemptNo = state.currentAttemptNoWith(backoff);
        if (currentAttemptNo < 0) {
            logger.debug("Exceeded the default number of max attempt: {}", (Object)state.maxTotalAttempts);
            return -1L;
        }
        long nextDelay = backoff.nextDelayMillis(currentAttemptNo);
        if (nextDelay < 0L) {
            logger.debug("Exceeded the number of max attempts in the backoff: {}", (Object)backoff);
            return -1L;
        }
        nextDelay = Math.max(nextDelay, millisAfterFromServer);
        if (state.timeoutForWholeRetryEnabled() && nextDelay > state.actualResponseTimeoutMillis()) {
            return -1L;
        }
        return nextDelay;
    }

    private static class State {
        private final int maxTotalAttempts;
        private final long responseTimeoutMillisForEachAttempt;
        private final long responseTimeoutMillis;
        private final long deadlineNanos;
        @Nullable
        private Backoff lastBackoff;
        private int currentAttemptNoWithLastBackoff;
        private int totalAttemptNo;

        State(int maxTotalAttempts, long responseTimeoutMillisForEachAttempt, long responseTimeoutMillis) {
            this.maxTotalAttempts = maxTotalAttempts;
            this.responseTimeoutMillisForEachAttempt = responseTimeoutMillisForEachAttempt;
            this.responseTimeoutMillis = responseTimeoutMillis;
            this.deadlineNanos = responseTimeoutMillis > 0L ? System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(responseTimeoutMillis) : 0L;
            this.totalAttemptNo = 1;
        }

        long responseTimeoutMillis() {
            if (!this.timeoutForWholeRetryEnabled()) {
                return this.responseTimeoutMillisForEachAttempt;
            }
            long actualResponseTimeoutMillis = this.actualResponseTimeoutMillis();
            if (actualResponseTimeoutMillis <= 0L) {
                return -1L;
            }
            if (this.responseTimeoutMillisForEachAttempt > 0L) {
                return Math.min(this.responseTimeoutMillisForEachAttempt, actualResponseTimeoutMillis);
            }
            return actualResponseTimeoutMillis;
        }

        boolean timeoutForWholeRetryEnabled() {
            return this.responseTimeoutMillis != 0L;
        }

        long actualResponseTimeoutMillis() {
            return TimeUnit.NANOSECONDS.toMillis(this.deadlineNanos - System.nanoTime());
        }

        int currentAttemptNoWith(Backoff backoff) {
            if (this.totalAttemptNo++ >= this.maxTotalAttempts) {
                return -1;
            }
            if (this.lastBackoff != backoff) {
                this.lastBackoff = backoff;
                this.currentAttemptNoWithLastBackoff = 1;
            }
            return this.currentAttemptNoWithLastBackoff++;
        }
    }
}

