/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.retry;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.retry.RetryStrategy;
import com.linecorp.armeria.client.retry.RetryingClient;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;

public abstract class RetryingClientBuilder<T extends RetryingClientBuilder<T, U, I, O>, U extends RetryingClient<I, O>, I extends Request, O extends Response> {
    final RetryStrategy<I, O> retryStrategy;
    int maxTotalAttempts = Flags.defaultMaxTotalAttempts();
    long responseTimeoutMillisForEachAttempt = Flags.defaultResponseTimeoutMillis();

    protected RetryingClientBuilder(RetryStrategy<I, O> retryStrategy) {
        this.retryStrategy = Objects.requireNonNull(retryStrategy, "retryStrategy");
    }

    final T self() {
        return (T)this;
    }

    public T maxTotalAttempts(int maxTotalAttempts) {
        Preconditions.checkArgument(maxTotalAttempts > 0, "maxTotalAttempts: %s (expected: > 0)", maxTotalAttempts);
        this.maxTotalAttempts = maxTotalAttempts;
        return this.self();
    }

    public T responseTimeoutMillisForEachAttempt(long responseTimeoutMillisForEachAttempt) {
        Preconditions.checkArgument(responseTimeoutMillisForEachAttempt >= 0L, "responseTimeoutMillisForEachAttempt: %s (expected: >= 0)", responseTimeoutMillisForEachAttempt);
        this.responseTimeoutMillisForEachAttempt = responseTimeoutMillisForEachAttempt;
        return this.self();
    }

    public T responseTimeoutForEachAttempt(Duration responseTimeoutForEachAttempt) {
        Preconditions.checkArgument(!Objects.requireNonNull(responseTimeoutForEachAttempt, "responseTimeoutForEachAttempt").isNegative(), "responseTimeoutForEachAttempt: %s (expected: >= 0)", (Object)responseTimeoutForEachAttempt);
        return this.responseTimeoutMillisForEachAttempt(responseTimeoutForEachAttempt.toMillis());
    }

    abstract U build(Client<I, O> var1);

    abstract Function<Client<I, O>, U> newDecorator();

    public String toString() {
        return this.toStringHelper().toString();
    }

    MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper(this).add("retryStrategy", this.retryStrategy).add("maxTotalAttempts", this.maxTotalAttempts).add("responseTimeoutMillisForEachAttempt", this.responseTimeoutMillisForEachAttempt);
    }
}

