/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.retry;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.ResponseTimeoutException;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.client.retry.RetryStrategy;
import com.linecorp.armeria.client.retry.RetryingClient;
import com.linecorp.armeria.client.retry.RetryingHttpClientBuilder;
import com.linecorp.armeria.common.FilteredHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpRequestDuplicator;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpResponseDuplicator;
import com.linecorp.armeria.common.stream.AbortedStreamException;
import com.linecorp.armeria.internal.HttpHeaderSubscriber;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import io.netty.util.concurrent.EventExecutor;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RetryingHttpClient
extends RetryingClient<HttpRequest, HttpResponse> {
    private static final Logger logger = LoggerFactory.getLogger(RetryingHttpClient.class);
    private final boolean useRetryAfter;
    private final int contentPreviewLength;

    public static Function<Client<HttpRequest, HttpResponse>, RetryingHttpClient> newDecorator(RetryStrategy<HttpRequest, HttpResponse> retryStrategy) {
        return new RetryingHttpClientBuilder(retryStrategy).newDecorator();
    }

    public static Function<Client<HttpRequest, HttpResponse>, RetryingHttpClient> newDecorator(RetryStrategy<HttpRequest, HttpResponse> retryStrategy, int maxTotalAttempts) {
        return ((RetryingHttpClientBuilder)new RetryingHttpClientBuilder(retryStrategy).maxTotalAttempts(maxTotalAttempts)).newDecorator();
    }

    public static Function<Client<HttpRequest, HttpResponse>, RetryingHttpClient> newDecorator(RetryStrategy<HttpRequest, HttpResponse> retryStrategy, int maxTotalAttempts, long responseTimeoutMillisForEachAttempt) {
        return ((RetryingHttpClientBuilder)((RetryingHttpClientBuilder)new RetryingHttpClientBuilder(retryStrategy).maxTotalAttempts(maxTotalAttempts)).responseTimeoutMillisForEachAttempt(responseTimeoutMillisForEachAttempt)).newDecorator();
    }

    RetryingHttpClient(Client<HttpRequest, HttpResponse> delegate, RetryStrategy<HttpRequest, HttpResponse> strategy, int totalMaxAttempts, long responseTimeoutMillisForEachAttempt, boolean useRetryAfter, int contentPreviewLength) {
        super(delegate, strategy, totalMaxAttempts, responseTimeoutMillisForEachAttempt);
        this.useRetryAfter = useRetryAfter;
        Preconditions.checkArgument(contentPreviewLength >= 0, "contentPreviewLength: %s (expected: >= 0)", contentPreviewLength);
        this.contentPreviewLength = contentPreviewLength;
    }

    @Override
    protected HttpResponse doExecute(ClientRequestContext ctx, HttpRequest req) throws Exception {
        CompletableFuture<HttpResponse> responseFuture = new CompletableFuture<HttpResponse>();
        HttpResponse res = HttpResponse.from(responseFuture);
        HttpRequestDuplicator reqDuplicator = new HttpRequestDuplicator(req, 0L, (EventExecutor)ctx.eventLoop());
        this.doExecute0(ctx, reqDuplicator, req, res, responseFuture);
        return res;
    }

    private void doExecute0(ClientRequestContext ctx, HttpRequestDuplicator rootReqDuplicator, HttpRequest originalReq, HttpResponse returnedRes, CompletableFuture<HttpResponse> future) {
        HttpResponse response;
        if (originalReq.completionFuture().isCompletedExceptionally() || returnedRes.isComplete()) {
            RetryingHttpClient.handleException(ctx, rootReqDuplicator, future, AbortedStreamException.get());
            return;
        }
        if (!this.setResponseTimeout(ctx)) {
            RetryingHttpClient.handleException(ctx, rootReqDuplicator, future, ResponseTimeoutException.get());
            return;
        }
        try {
            response = (HttpResponse)this.executeDelegate(ctx, (HttpRequest)rootReqDuplicator.duplicateStream());
        }
        catch (Exception e) {
            response = HttpResponse.ofFailure(e);
        }
        HttpResponseDuplicator resDuplicator = new HttpResponseDuplicator(response, RetryingHttpClient.maxSignalLength(ctx.maxResponseLength()), (EventExecutor)ctx.eventLoop());
        this.retryStrategy().shouldRetry((HttpRequest)rootReqDuplicator.duplicateStream(), this.contentPreviewResponse(resDuplicator)).whenComplete((backoff, unused) -> {
            if (backoff != null) {
                long millisAfter = this.useRetryAfter ? RetryingHttpClient.getRetryAfterMillis(this.contentPreviewResponse(resDuplicator)) : -1L;
                long nextDelay = this.getNextDelay(ctx, (Backoff)backoff, millisAfter);
                if (nextDelay < 0L) {
                    RetryingHttpClient.finishRetryWithCurrentResponse(ctx, rootReqDuplicator, future, resDuplicator);
                    return;
                }
                resDuplicator.close();
                RetryingHttpClient.scheduleNextRetry(ctx, cause -> RetryingHttpClient.handleException(ctx, rootReqDuplicator, future, cause), () -> this.doExecute0(ctx, rootReqDuplicator, originalReq, returnedRes, future), nextDelay);
            } else {
                RetryingHttpClient.finishRetryWithCurrentResponse(ctx, rootReqDuplicator, future, resDuplicator);
            }
        });
    }

    private static void handleException(ClientRequestContext ctx, HttpRequestDuplicator rootReqDuplicator, CompletableFuture<HttpResponse> future, Throwable cause) {
        RetryingHttpClient.onRetryingComplete(ctx);
        future.completeExceptionally(cause);
        rootReqDuplicator.close();
    }

    private static int maxSignalLength(long maxResponseLength) {
        if (maxResponseLength == 0L || maxResponseLength > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)maxResponseLength;
    }

    private ContentPreviewResponse contentPreviewResponse(HttpResponseDuplicator resDuplicator) {
        return new ContentPreviewResponse((HttpResponse)resDuplicator.duplicateStream(), this.contentPreviewLength);
    }

    private static long getRetryAfterMillis(HttpResponse res) {
        HttpHeaders headers = RetryingHttpClient.getHttpHeaders(res);
        long millisAfter = -1L;
        String value = (String)headers.get(HttpHeaderNames.RETRY_AFTER);
        if (value != null) {
            try {
                millisAfter = Duration.ofSeconds(Integer.parseInt(value)).toMillis();
                return millisAfter;
            }
            catch (Exception exception) {
                try {
                    Long later = headers.getTimeMillis(HttpHeaderNames.RETRY_AFTER);
                    millisAfter = later - System.currentTimeMillis();
                }
                catch (Exception ignored) {
                    logger.debug("The retryAfter: {}, from the server is neither an HTTP date nor a second.", (Object)value);
                }
            }
        }
        return millisAfter;
    }

    private static HttpHeaders getHttpHeaders(HttpResponse res) {
        CompletableFuture<HttpHeaders> future = new CompletableFuture<HttpHeaders>();
        HttpHeaderSubscriber subscriber = new HttpHeaderSubscriber(future);
        res.completionFuture().whenComplete((BiConsumer)subscriber);
        res.subscribe(subscriber);
        return (HttpHeaders)((CompletableFuture)future.handle((headers, thrown) -> thrown != null ? HttpHeaders.EMPTY_HEADERS : headers)).join();
    }

    private static void finishRetryWithCurrentResponse(ClientRequestContext ctx, HttpRequestDuplicator rootReqDuplicator, CompletableFuture<HttpResponse> res, HttpResponseDuplicator resDuplicator) {
        RetryingHttpClient.onRetryingComplete(ctx);
        res.complete((HttpResponse)resDuplicator.duplicateStream(true));
        rootReqDuplicator.close();
    }

    private static class ContentPreviewResponse
    extends FilteredHttpResponse {
        private final int contentPreviewLength;
        private int contentLength;
        @Nullable
        private Subscription subscription;

        ContentPreviewResponse(HttpResponse delegate, int contentPreviewLength) {
            super(delegate);
            this.contentPreviewLength = contentPreviewLength;
        }

        @Override
        protected void beforeSubscribe(Subscriber<? super HttpObject> subscriber, Subscription subscription) {
            this.subscription = subscription;
        }

        @Override
        protected HttpObject filter(HttpObject obj) {
            if (obj instanceof HttpData) {
                int dataLength = ((HttpData)obj).length();
                this.contentLength += dataLength;
                if (this.contentLength >= this.contentPreviewLength) {
                    assert (this.subscription != null);
                    this.subscription.cancel();
                }
            }
            return obj;
        }
    }
}

