/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.retry;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.retry.RetryStrategy;
import com.linecorp.armeria.client.retry.RetryingClientBuilder;
import com.linecorp.armeria.client.retry.RetryingHttpClient;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.util.function.Function;

public class RetryingHttpClientBuilder
extends RetryingClientBuilder<RetryingHttpClientBuilder, RetryingHttpClient, HttpRequest, HttpResponse> {
    private static final int DEFAULT_CONTENT_PREVIEW_LENGTH = 0;
    private boolean useRetryAfter;
    private int contentPreviewLength = 0;

    public RetryingHttpClientBuilder(RetryStrategy<HttpRequest, HttpResponse> retryStrategy) {
        super(retryStrategy);
    }

    public RetryingHttpClientBuilder useRetryAfter(boolean useRetryAfter) {
        this.useRetryAfter = useRetryAfter;
        return (RetryingHttpClientBuilder)this.self();
    }

    public RetryingHttpClientBuilder contentPreviewLength(int contentPreviewLength) {
        Preconditions.checkArgument(contentPreviewLength >= 0, "contentPreviewLength: %s (expected: >= 0)", contentPreviewLength);
        this.contentPreviewLength = contentPreviewLength;
        return (RetryingHttpClientBuilder)this.self();
    }

    @Override
    public RetryingHttpClient build(Client<HttpRequest, HttpResponse> delegate) {
        return new RetryingHttpClient(delegate, this.retryStrategy, this.maxTotalAttempts, this.responseTimeoutMillisForEachAttempt, this.useRetryAfter, this.contentPreviewLength);
    }

    @Override
    public Function<Client<HttpRequest, HttpResponse>, RetryingHttpClient> newDecorator() {
        return delegate -> new RetryingHttpClient((Client<HttpRequest, HttpResponse>)delegate, this.retryStrategy, this.maxTotalAttempts, this.responseTimeoutMillisForEachAttempt, this.useRetryAfter, this.contentPreviewLength);
    }

    @Override
    public String toString() {
        return this.toStringHelper().add("useRetryAfter", this.useRetryAfter).toString();
    }
}

