/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.retry;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.ResponseTimeoutException;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.client.retry.RetryStrategy;
import com.linecorp.armeria.client.retry.RetryingClient;
import com.linecorp.armeria.client.retry.RetryingRpcClientBuilder;
import com.linecorp.armeria.common.DefaultRpcResponse;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.RpcResponse;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class RetryingRpcClient
extends RetryingClient<RpcRequest, RpcResponse> {
    public static Function<Client<RpcRequest, RpcResponse>, RetryingRpcClient> newDecorator(RetryStrategy<RpcRequest, RpcResponse> retryStrategy) {
        return new RetryingRpcClientBuilder(retryStrategy).newDecorator();
    }

    public static Function<Client<RpcRequest, RpcResponse>, RetryingRpcClient> newDecorator(RetryStrategy<RpcRequest, RpcResponse> retryStrategy, int maxTotalAttempts) {
        return ((RetryingRpcClientBuilder)new RetryingRpcClientBuilder(retryStrategy).maxTotalAttempts(maxTotalAttempts)).newDecorator();
    }

    public static Function<Client<RpcRequest, RpcResponse>, RetryingRpcClient> newDecorator(RetryStrategy<RpcRequest, RpcResponse> retryStrategy, int maxTotalAttempts, long responseTimeoutMillisForEachAttempt) {
        return ((RetryingRpcClientBuilder)((RetryingRpcClientBuilder)new RetryingRpcClientBuilder(retryStrategy).maxTotalAttempts(maxTotalAttempts)).responseTimeoutMillisForEachAttempt(responseTimeoutMillisForEachAttempt)).newDecorator();
    }

    RetryingRpcClient(Client<RpcRequest, RpcResponse> delegate, RetryStrategy<RpcRequest, RpcResponse> retryStrategy, int totalMaxAttempts, long responseTimeoutMillisForEachAttempt) {
        super(delegate, retryStrategy, totalMaxAttempts, responseTimeoutMillisForEachAttempt);
    }

    @Override
    protected RpcResponse doExecute(ClientRequestContext ctx, RpcRequest req) throws Exception {
        CompletableFuture<RpcResponse> future = new CompletableFuture<RpcResponse>();
        RpcResponse res = RpcResponse.from(future);
        this.doExecute0(ctx, req, res, future);
        return res;
    }

    private void doExecute0(ClientRequestContext ctx, RpcRequest req, RpcResponse returnedRes, CompletableFuture<RpcResponse> future) {
        if (returnedRes.isDone()) {
            RetryingRpcClient.handleException(ctx, future, new CancellationException("the response returned to the client has been cancelled"));
            return;
        }
        if (!this.setResponseTimeout(ctx)) {
            RetryingRpcClient.handleException(ctx, future, ResponseTimeoutException.get());
            return;
        }
        RpcResponse res = this.getResponse(ctx, req);
        res.whenComplete((unused1, unused2) -> this.retryStrategy().shouldRetry(req, res).whenComplete((backoff, unused3) -> {
            if (backoff != null) {
                long nextDelay = this.getNextDelay(ctx, (Backoff)backoff);
                if (nextDelay < 0L) {
                    RetryingRpcClient.onRetryingComplete(ctx);
                    future.complete(res);
                    return;
                }
                RetryingRpcClient.scheduleNextRetry(ctx, cause -> RetryingRpcClient.handleException(ctx, future, cause), () -> this.doExecute0(ctx, req, returnedRes, future), nextDelay);
            } else {
                RetryingRpcClient.onRetryingComplete(ctx);
                future.complete(res);
            }
        }));
    }

    private static void handleException(ClientRequestContext ctx, CompletableFuture<RpcResponse> future, Throwable cause) {
        RetryingRpcClient.onRetryingComplete(ctx);
        future.completeExceptionally(cause);
    }

    private RpcResponse getResponse(ClientRequestContext ctx, RpcRequest req) {
        try {
            return (RpcResponse)this.executeDelegate(ctx, req);
        }
        catch (Exception e) {
            return new DefaultRpcResponse(e);
        }
    }
}

