/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RequestContextAwareCompletableFuture;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.SafeCloseable;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class AbstractRequestContext
implements RequestContext {
    private static final CancellationException CANCELLATION_EXCEPTION = Exceptions.clearTrace(new CancellationException());
    private boolean timedOut;

    @Override
    public final EventLoop contextAwareEventLoop() {
        return RequestContext.super.contextAwareEventLoop();
    }

    @Override
    public final Executor makeContextAware(Executor executor) {
        return RequestContext.super.makeContextAware(executor);
    }

    @Override
    public final <T> Callable<T> makeContextAware(Callable<T> callable) {
        return () -> {
            SafeCloseable ignored = this.pushIfAbsent();
            Throwable throwable = null;
            try {
                Object v = callable.call();
                return v;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored != null) {
                    AbstractRequestContext.$closeResource(throwable, ignored);
                }
            }
        };
    }

    @Override
    public final Runnable makeContextAware(Runnable runnable) {
        return () -> {
            SafeCloseable ignored = this.pushIfAbsent();
            Throwable throwable = null;
            try {
                runnable.run();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored != null) {
                    AbstractRequestContext.$closeResource(throwable, ignored);
                }
            }
        };
    }

    @Override
    public final <T, R> Function<T, R> makeContextAware(Function<T, R> function) {
        return t -> {
            SafeCloseable ignored = this.pushIfAbsent();
            Throwable throwable = null;
            try {
                Object r = function.apply(t);
                return r;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored != null) {
                    AbstractRequestContext.$closeResource(throwable, ignored);
                }
            }
        };
    }

    @Override
    public final <T, U, V> BiFunction<T, U, V> makeContextAware(BiFunction<T, U, V> function) {
        return (t, u) -> {
            SafeCloseable ignored = this.pushIfAbsent();
            Throwable throwable = null;
            try {
                Object r = function.apply(t, u);
                return r;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored != null) {
                    AbstractRequestContext.$closeResource(throwable, ignored);
                }
            }
        };
    }

    @Override
    public final <T> Consumer<T> makeContextAware(Consumer<T> action) {
        return t -> {
            SafeCloseable ignored = this.pushIfAbsent();
            Throwable throwable = null;
            try {
                action.accept(t);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored != null) {
                    AbstractRequestContext.$closeResource(throwable, ignored);
                }
            }
        };
    }

    @Override
    public final <T, U> BiConsumer<T, U> makeContextAware(BiConsumer<T, U> action) {
        return (t, u) -> {
            SafeCloseable ignored = this.pushIfAbsent();
            Throwable throwable = null;
            try {
                action.accept(t, u);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored != null) {
                    AbstractRequestContext.$closeResource(throwable, ignored);
                }
            }
        };
    }

    @Override
    public final <T> FutureListener<T> makeContextAware(FutureListener<T> listener) {
        return future -> this.invokeOperationComplete((GenericFutureListener)listener, (Future)future);
    }

    @Override
    public final ChannelFutureListener makeContextAware(ChannelFutureListener listener) {
        return future -> this.invokeOperationComplete((GenericFutureListener)listener, (Future)future);
    }

    @Override
    public final <T extends Future<?>> GenericFutureListener<T> makeContextAware(GenericFutureListener<T> listener) {
        return future -> this.invokeOperationComplete(listener, future);
    }

    @Override
    public final <T> CompletionStage<T> makeContextAware(CompletionStage<T> stage) {
        RequestContextAwareCompletableFuture future = new RequestContextAwareCompletableFuture(this);
        stage.whenComplete((result, cause) -> {
            SafeCloseable ignored = this.pushIfAbsent();
            Throwable throwable = null;
            try {
                if (cause != null) {
                    future.completeExceptionally((Throwable)cause);
                } else {
                    future.complete(result);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored != null) {
                    AbstractRequestContext.$closeResource(throwable, ignored);
                }
            }
        });
        return future;
    }

    @Override
    public final <T> CompletableFuture<T> makeContextAware(CompletableFuture<T> future) {
        return RequestContext.super.makeContextAware(future);
    }

    @Override
    public boolean isTimedOut() {
        return this.timedOut;
    }

    public void setTimedOut() {
        this.timedOut = true;
    }

    private <T extends Future<?>> void invokeOperationComplete(GenericFutureListener<T> listener, T future) throws Exception {
        try (SafeCloseable ignored = this.pushIfAbsent();){
            listener.operationComplete(future);
        }
    }

    @Override
    public final void onEnter(Runnable callback) {
        RequestContext.super.onEnter(callback);
    }

    @Override
    public final void onExit(Runnable callback) {
        RequestContext.super.onExit(callback);
    }

    @Override
    public final void resolvePromise(Promise<?> promise, Object result) {
        RequestContext.super.resolvePromise(promise, result);
    }

    @Override
    public final void rejectPromise(Promise<?> promise, Throwable cause) {
        RequestContext.super.rejectPromise(promise, cause);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }
}

