/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.DefaultAggregatedHttpMessage;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.internal.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;

public interface AggregatedHttpMessage {
    public static AggregatedHttpMessage of(HttpMethod method, String path) {
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(path, "path");
        return AggregatedHttpMessage.of(HttpHeaders.of(method, path));
    }

    public static AggregatedHttpMessage of(HttpMethod method, String path, MediaType mediaType, String content) {
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(mediaType, "mediaType");
        return AggregatedHttpMessage.of(method, path, mediaType, content.getBytes(mediaType.charset().orElse(StandardCharsets.UTF_8)));
    }

    public static AggregatedHttpMessage of(HttpMethod method, String path, MediaType mediaType, String format, Object ... args) {
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(format, "format");
        Objects.requireNonNull(args, "args");
        return AggregatedHttpMessage.of(method, path, mediaType, String.format(Locale.ENGLISH, format, args).getBytes(mediaType.charset().orElse(StandardCharsets.UTF_8)));
    }

    public static AggregatedHttpMessage of(HttpMethod method, String path, MediaType mediaType, byte[] content) {
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(content, "content");
        return AggregatedHttpMessage.of(method, path, mediaType, HttpData.of(content));
    }

    public static AggregatedHttpMessage of(HttpMethod method, String path, MediaType mediaType, byte[] content, int offset, int length) {
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(content, "content");
        return AggregatedHttpMessage.of(method, path, mediaType, HttpData.of(content, offset, length));
    }

    public static AggregatedHttpMessage of(HttpMethod method, String path, MediaType mediaType, HttpData content) {
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(content, "content");
        return AggregatedHttpMessage.of(method, path, mediaType, content, HttpHeaders.EMPTY_HEADERS);
    }

    public static AggregatedHttpMessage of(HttpMethod method, String path, MediaType mediaType, HttpData content, HttpHeaders trailingHeaders) {
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(trailingHeaders, "trailingHeaders");
        return AggregatedHttpMessage.of(HttpHeaders.of(method, path).contentType(mediaType), content, trailingHeaders);
    }

    public static AggregatedHttpMessage of(int statusCode) {
        return AggregatedHttpMessage.of(HttpStatus.valueOf(statusCode));
    }

    public static AggregatedHttpMessage of(HttpStatus status) {
        Objects.requireNonNull(status, "status");
        if (ArmeriaHttpUtil.isContentAlwaysEmpty(status)) {
            return AggregatedHttpMessage.of(HttpHeaders.of(status));
        }
        return AggregatedHttpMessage.of(status, MediaType.PLAIN_TEXT_UTF_8, status.toHttpData());
    }

    public static AggregatedHttpMessage of(HttpStatus status, MediaType mediaType, String content) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(content, "content");
        return AggregatedHttpMessage.of(status, mediaType, content.getBytes(mediaType.charset().orElse(StandardCharsets.UTF_8)));
    }

    public static AggregatedHttpMessage of(HttpStatus status, MediaType mediaType, String format, Object ... args) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(format, "format");
        Objects.requireNonNull(args, "args");
        return AggregatedHttpMessage.of(status, mediaType, String.format(Locale.ENGLISH, format, args).getBytes(mediaType.charset().orElse(StandardCharsets.UTF_8)));
    }

    public static AggregatedHttpMessage of(HttpStatus status, MediaType mediaType, byte[] content) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(content, "content");
        return AggregatedHttpMessage.of(status, mediaType, HttpData.of(content));
    }

    public static AggregatedHttpMessage of(HttpStatus status, MediaType mediaType, byte[] content, int offset, int length) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(content, "content");
        return AggregatedHttpMessage.of(status, mediaType, HttpData.of(content, offset, length));
    }

    public static AggregatedHttpMessage of(HttpStatus status, MediaType mediaType, HttpData content) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(content, "content");
        return AggregatedHttpMessage.of(status, mediaType, content, HttpHeaders.EMPTY_HEADERS);
    }

    public static AggregatedHttpMessage of(HttpStatus status, MediaType mediaType, HttpData content, HttpHeaders trailingHeaders) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(trailingHeaders, "trailingHeaders");
        HttpHeaders headers = (HttpHeaders)HttpHeaders.of(status).contentType(mediaType).setInt(HttpHeaderNames.CONTENT_LENGTH, content.length());
        return AggregatedHttpMessage.of(headers, content, trailingHeaders);
    }

    public static AggregatedHttpMessage of(HttpHeaders headers) {
        Objects.requireNonNull(headers, "headers");
        return AggregatedHttpMessage.of(headers, HttpData.EMPTY_DATA, HttpHeaders.EMPTY_HEADERS);
    }

    public static AggregatedHttpMessage of(HttpHeaders headers, HttpData content) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(content, "content");
        return AggregatedHttpMessage.of(headers, content, HttpHeaders.EMPTY_HEADERS);
    }

    public static AggregatedHttpMessage of(HttpHeaders headers, HttpData content, HttpHeaders trailingHeaders) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(trailingHeaders, "trailingHeaders");
        return AggregatedHttpMessage.of(Collections.emptyList(), headers, content, trailingHeaders);
    }

    public static AggregatedHttpMessage of(Iterable<HttpHeaders> informationals, HttpHeaders headers, HttpData content, HttpHeaders trailingHeaders) {
        Objects.requireNonNull(informationals, "informationals");
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(trailingHeaders, "trailingHeaders");
        HttpStatus status = headers.status();
        if (status != null) {
            if (!ArmeriaHttpUtil.isContentAlwaysEmptyWithValidation(status, content, trailingHeaders) && !headers.contains(HttpHeaderNames.CONTENT_LENGTH)) {
                headers.setInt(HttpHeaderNames.CONTENT_LENGTH, content.length());
            }
        } else if (content.isEmpty()) {
            headers.remove(HttpHeaderNames.CONTENT_LENGTH);
        } else {
            headers.setInt(HttpHeaderNames.CONTENT_LENGTH, content.length());
        }
        return new DefaultAggregatedHttpMessage(ImmutableList.copyOf(informationals), headers, content, trailingHeaders);
    }

    public List<HttpHeaders> informationals();

    public HttpHeaders headers();

    public HttpHeaders trailingHeaders();

    public HttpData content();

    @Nullable
    default public String scheme() {
        return this.headers().scheme();
    }

    @Nullable
    default public HttpMethod method() {
        return this.headers().method();
    }

    @Nullable
    default public String path() {
        return this.headers().path();
    }

    @Nullable
    default public String authority() {
        return this.headers().authority();
    }

    @Nullable
    default public HttpStatus status() {
        return this.headers().status();
    }

    @Deprecated
    default public HttpRequest toHttpRequest() {
        return HttpRequest.of(this);
    }

    @Deprecated
    default public HttpResponse toHttpResponse() {
        return HttpResponse.of(this);
    }
}

