/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.util.EventLoopGroups;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class CommonPools {
    private static final Executor BLOCKING_TASK_EXECUTOR;
    private static final EventLoopGroup WORKER_GROUP;

    public static Executor blockingTaskExecutor() {
        return BLOCKING_TASK_EXECUTOR;
    }

    public static EventLoopGroup workerGroup() {
        return WORKER_GROUP;
    }

    private CommonPools() {
    }

    static {
        ThreadPoolExecutor blockingTaskExecutor = new ThreadPoolExecutor(Flags.numCommonBlockingTaskThreads(), Flags.numCommonBlockingTaskThreads(), 60L, TimeUnit.SECONDS, new LinkedTransferQueue<Runnable>(), (ThreadFactory)new DefaultThreadFactory("armeria-common-blocking-tasks", true));
        blockingTaskExecutor.allowCoreThreadTimeOut(true);
        BLOCKING_TASK_EXECUTOR = blockingTaskExecutor;
        WORKER_GROUP = EventLoopGroups.newEventLoopGroup(Flags.numCommonWorkers(), "armeria-common-worker", true);
    }
}

