/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.StringValueConverter;
import com.linecorp.armeria.internal.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.ValueConverter;
import io.netty.util.AsciiString;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class DefaultHttpHeaders
extends DefaultHeaders<AsciiString, String, HttpHeaders>
implements HttpHeaders {
    private static final DefaultHeaders.NameValidator<AsciiString> HTTP2_NAME_VALIDATOR = name -> Preconditions.checkArgument(name != null && !name.isEmpty(), "empty headers are not allowed: %s", name);
    private final boolean endOfStream;
    @Nullable
    private HttpMethod method;
    @Nullable
    private HttpStatus status;
    @Nullable
    private MediaType contentType;

    public DefaultHttpHeaders() {
        this(true);
    }

    public DefaultHttpHeaders(boolean validate) {
        this(validate, 16);
    }

    public DefaultHttpHeaders(boolean validate, int initialCapacity) {
        this(validate, initialCapacity, false);
    }

    public DefaultHttpHeaders(boolean validate, int initialCapacity, boolean endOfStream) {
        super(ArmeriaHttpUtil.HTTP2_HEADER_NAME_HASHER, (ValueConverter)StringValueConverter.INSTANCE, validate ? HTTP2_NAME_VALIDATOR : DefaultHeaders.NameValidator.NOT_NULL, initialCapacity);
        this.endOfStream = endOfStream;
    }

    @Override
    @Nullable
    public HttpMethod method() {
        HttpMethod method = this.method;
        if (method != null) {
            return method;
        }
        String methodStr = (String)this.get(HttpHeaderNames.METHOD);
        if (methodStr == null) {
            return null;
        }
        this.method = HttpMethod.isSupported(methodStr) ? HttpMethod.valueOf(methodStr) : HttpMethod.UNKNOWN;
        return this.method;
    }

    @Override
    public HttpHeaders method(HttpMethod method) {
        Objects.requireNonNull(method, "method");
        this.method = method;
        this.set(HttpHeaderNames.METHOD, method.name());
        return this;
    }

    @Override
    public String scheme() {
        return (String)this.get(HttpHeaderNames.SCHEME);
    }

    @Override
    public HttpHeaders scheme(String scheme) {
        Objects.requireNonNull(scheme, "scheme");
        this.set(HttpHeaderNames.SCHEME, scheme);
        return this;
    }

    @Override
    public String authority() {
        return (String)this.get(HttpHeaderNames.AUTHORITY);
    }

    @Override
    public HttpHeaders authority(String authority) {
        Objects.requireNonNull(authority, "authority");
        this.set(HttpHeaderNames.AUTHORITY, authority);
        return this;
    }

    @Override
    public String path() {
        return (String)this.get(HttpHeaderNames.PATH);
    }

    @Override
    public HttpHeaders path(String path) {
        Objects.requireNonNull(path, "path");
        this.set(HttpHeaderNames.PATH, path);
        return this;
    }

    @Override
    @Nullable
    public HttpStatus status() {
        HttpStatus status = this.status;
        if (status != null) {
            return status;
        }
        String statusStr = (String)this.get(HttpHeaderNames.STATUS);
        if (statusStr == null) {
            return null;
        }
        try {
            this.status = HttpStatus.valueOf(Integer.valueOf(statusStr));
            return this.status;
        }
        catch (NumberFormatException ignored) {
            throw new IllegalStateException("invalid status: " + statusStr);
        }
    }

    @Override
    public HttpHeaders status(int statusCode) {
        HttpStatus status = this.status = HttpStatus.valueOf(statusCode);
        this.set(HttpHeaderNames.STATUS, status.codeAsText());
        return this;
    }

    @Override
    public HttpHeaders status(HttpStatus status) {
        Objects.requireNonNull(status, "status");
        this.set(HttpHeaderNames.STATUS, status.codeAsText());
        return this;
    }

    @Override
    @Nullable
    public MediaType contentType() {
        String contentTypeString = (String)this.get(HttpHeaderNames.CONTENT_TYPE);
        if (contentTypeString == null) {
            return null;
        }
        MediaType contentType = this.contentType;
        if (contentType != null && Ascii.equalsIgnoreCase(contentType.toString(), contentTypeString.trim())) {
            return contentType;
        }
        try {
            this.contentType = MediaType.parse(contentTypeString);
            return this.contentType;
        }
        catch (IllegalArgumentException unused) {
            return null;
        }
    }

    @Override
    public HttpHeaders contentType(MediaType contentType) {
        Objects.requireNonNull(contentType, "contentType");
        this.contentType = contentType;
        return (HttpHeaders)this.set(HttpHeaderNames.CONTENT_TYPE, contentType.toString());
    }

    @Override
    public boolean isEndOfStream() {
        return this.endOfStream;
    }

    public String toString() {
        int size = this.size();
        if (size == 0) {
            return "[]";
        }
        StringBuilder buf = new StringBuilder(this.size() * 16).append('[');
        String separator = "";
        for (AsciiString name : this.names()) {
            List values = this.getAll(name);
            for (int i = 0; i < values.size(); ++i) {
                buf.append(separator);
                buf.append((CharSequence)name).append('=').append((String)values.get(i));
            }
            separator = ", ";
        }
        return buf.append(']').toString();
    }

    protected DefaultHeaders.HeaderEntry<AsciiString, String> newHeaderEntry(int h, AsciiString name, String value, DefaultHeaders.HeaderEntry<AsciiString, String> next) {
        return super.newHeaderEntry(h, (Object)name.toLowerCase(), (Object)value, next);
    }
}

