/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class DefaultRpcRequest
implements RpcRequest {
    private final Class<?> serviceType;
    private final String method;
    private final List<Object> params;

    public DefaultRpcRequest(Class<?> serviceType, String method) {
        this(serviceType, method, Collections.emptyList());
    }

    public DefaultRpcRequest(Class<?> serviceType, String method, @Nullable Object parameter) {
        this(serviceType, method, Collections.singletonList(parameter));
    }

    public DefaultRpcRequest(Class<?> serviceType, String method, Iterable<?> params) {
        this(serviceType, method, DefaultRpcRequest.copyParams(params));
    }

    public DefaultRpcRequest(Class<?> serviceType, String method, Object ... params) {
        this(serviceType, method, DefaultRpcRequest.copyParams(params));
    }

    private DefaultRpcRequest(Class<?> serviceType, String method, List<Object> params) {
        this.serviceType = Objects.requireNonNull(serviceType, "serviceType");
        this.method = Objects.requireNonNull(method, "method");
        this.params = params;
    }

    private static List<Object> copyParams(Iterable<?> params) {
        Objects.requireNonNull(params, "params");
        ArrayList<Object> copy = params instanceof Collection ? new ArrayList(((Collection)params).size()) : new ArrayList(8);
        for (Object p : params) {
            copy.add(p);
        }
        return Collections.unmodifiableList(copy);
    }

    private static List<Object> copyParams(Object ... params) {
        return Collections.unmodifiableList(Arrays.asList(Objects.requireNonNull(params, "params")));
    }

    @Override
    public final Class<?> serviceType() {
        return this.serviceType;
    }

    @Override
    public final String method() {
        return this.method;
    }

    @Override
    public final List<Object> params() {
        return this.params;
    }

    public int hashCode() {
        return this.method().hashCode() * 31 + this.params().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultRpcRequest)) {
            return false;
        }
        DefaultRpcRequest that = (DefaultRpcRequest)obj;
        return this.method().equals(that.method()) && this.params().equals(that.params());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("serviceType", this.simpleServiceName()).add("method", this.method()).add("params", this.params()).toString();
    }

    protected final String simpleServiceName() {
        Class<?> serviceType = this.serviceType();
        String fqcn = serviceType.getName();
        int lastDot = fqcn.lastIndexOf(46);
        return lastDot < 0 ? fqcn : fqcn.substring(lastDot + 1);
    }
}

