/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.RpcResponse;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

public class DefaultRpcResponse
extends CompletableFuture<Object>
implements RpcResponse {
    private static final CancellationException CANCELLED = Exceptions.clearTrace(new CancellationException());
    private static final AtomicReferenceFieldUpdater<DefaultRpcResponse, Throwable> causeUpdater = AtomicReferenceFieldUpdater.newUpdater(DefaultRpcResponse.class, Throwable.class, "cause");
    @Nullable
    private volatile Throwable cause;

    public DefaultRpcResponse() {
    }

    public DefaultRpcResponse(@Nullable Object result) {
        this.complete(result);
    }

    public DefaultRpcResponse(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        this.completeExceptionally(cause);
    }

    @Override
    @Nullable
    public final Throwable cause() {
        return this.cause;
    }

    @Override
    public boolean completeExceptionally(Throwable cause) {
        causeUpdater.compareAndSet(this, null, Objects.requireNonNull(cause));
        return super.completeExceptionally(cause);
    }

    @Override
    public void obtrudeException(Throwable cause) {
        this.cause = Objects.requireNonNull(cause);
        super.obtrudeException(cause);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.completeExceptionally(CANCELLED) || this.isCancelled();
    }

    @Override
    public String toString() {
        if (this.isDone()) {
            if (this.isCompletedExceptionally()) {
                return MoreObjects.toStringHelper(this).add("cause", this.cause).toString();
            }
            return MoreObjects.toStringHelper(this).addValue(this.getNow(null)).toString();
        }
        int count = this.getNumberOfDependents();
        if (count == 0) {
            return MoreObjects.toStringHelper(this).addValue("not completed").toString();
        }
        return MoreObjects.toStringHelper(this).addValue("not completed").add("dependents", count).toString();
    }
}

