/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.shaded.caffeine.cache.CaffeineSpec;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.internal.shaded.guava.base.CharMatcher;
import com.linecorp.armeria.internal.shaded.guava.base.Splitter;
import com.linecorp.armeria.server.annotation.ExceptionVerbosity;
import io.netty.channel.epoll.Epoll;
import io.netty.handler.ssl.OpenSsl;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Flags {
    private static final Logger logger;
    private static final Splitter CSV_SPLITTER;
    private static final String PREFIX = "com.linecorp.armeria.";
    private static final int NUM_CPU_CORES;
    private static final boolean VERBOSE_EXCEPTIONS;
    private static final boolean VERBOSE_RESPONSES;
    private static final boolean HAS_WSLENV;
    private static final boolean USE_EPOLL;
    private static final boolean USE_OPENSSL;
    private static final int DEFAULT_MAX_NUM_CONNECTIONS = Integer.MAX_VALUE;
    private static final int MAX_NUM_CONNECTIONS;
    private static final int DEFAULT_NUM_COMMON_WORKERS;
    private static final int NUM_COMMON_WORKERS;
    private static final int DEFAULT_NUM_COMMON_BLOCKING_TASK_THREADS = 200;
    private static final int NUM_COMMON_BLOCKING_TASK_THREADS;
    private static final long DEFAULT_DEFAULT_MAX_REQUEST_LENGTH = 0xA00000L;
    private static final long DEFAULT_MAX_REQUEST_LENGTH;
    private static final long DEFAULT_DEFAULT_MAX_RESPONSE_LENGTH = 0xA00000L;
    private static final long DEFAULT_MAX_RESPONSE_LENGTH;
    private static final long DEFAULT_DEFAULT_REQUEST_TIMEOUT_MILLIS = 10000L;
    private static final long DEFAULT_REQUEST_TIMEOUT_MILLIS;
    private static final long DEFAULT_DEFAULT_RESPONSE_TIMEOUT_MILLIS = 15000L;
    private static final long DEFAULT_RESPONSE_TIMEOUT_MILLIS;
    private static final long DEFAULT_DEFAULT_CONNECT_TIMEOUT_MILLIS = 3200L;
    private static final long DEFAULT_CONNECT_TIMEOUT_MILLIS;
    private static final long DEFAULT_DEFAULT_SERVER_IDLE_TIMEOUT_MILLIS = 15000L;
    private static final long DEFAULT_SERVER_IDLE_TIMEOUT_MILLIS;
    private static final long DEFAULT_DEFAULT_CLIENT_IDLE_TIMEOUT_MILLIS = 10000L;
    private static final long DEFAULT_CLIENT_IDLE_TIMEOUT_MILLIS;
    private static final int DEFAULT_DEFAULT_HTTP2_INITIAL_CONNECTION_WINDOW_SIZE = 0x100000;
    private static final int DEFAULT_HTTP2_INITIAL_CONNECTION_WINDOW_SIZE;
    private static final int DEFAULT_DEFAULT_HTTP2_INITIAL_STREAM_WINDOW_SIZE = 0x100000;
    private static final int DEFAULT_HTTP2_INITIAL_STREAM_WINDOW_SIZE;
    private static final int DEFAULT_DEFAULT_HTTP2_MAX_FRAME_SIZE = 16384;
    private static final int DEFAULT_HTTP2_MAX_FRAME_SIZE;
    private static final long DEFAULT_DEFAULT_HTTP2_MAX_STREAMS_PER_CONNECTION = Integer.MAX_VALUE;
    private static final long DEFAULT_HTTP2_MAX_STREAMS_PER_CONNECTION;
    private static final long DEFAULT_DEFAULT_HTTP2_MAX_HEADER_LIST_SIZE = 8192L;
    private static final long DEFAULT_HTTP2_MAX_HEADER_LIST_SIZE;
    private static final int DEFAULT_DEFAULT_HTTP1_MAX_INITIAL_LINE_LENGTH = 4096;
    private static final int DEFAULT_MAX_HTTP1_INITIAL_LINE_LENGTH;
    private static final int DEFAULT_DEFAULT_HTTP1_MAX_HEADER_SIZE = 8192;
    private static final int DEFAULT_MAX_HTTP1_HEADER_SIZE;
    private static final int DEFAULT_DEFAULT_HTTP1_MAX_CHUNK_SIZE = 8192;
    private static final int DEFAULT_HTTP1_MAX_CHUNK_SIZE;
    private static final boolean DEFAULT_USE_HTTP2_PREFACE;
    private static final boolean DEFAULT_USE_HTTP1_PIPELINING;
    private static final String DEFAULT_DEFAULT_BACKOFF_SPEC = "exponential=200:10000,jitter=0.2";
    private static final String DEFAULT_BACKOFF_SPEC;
    private static final int DEFAULT_DEFAULT_MAX_TOTAL_ATTEMPTS = 10;
    private static final int DEFAULT_MAX_TOTAL_ATTEMPTS;
    private static final String DEFAULT_ROUTE_CACHE_SPEC = "maximumSize=4096";
    private static final Optional<String> ROUTE_CACHE_SPEC;
    private static final String DEFAULT_COMPOSITE_SERVICE_CACHE_SPEC = "maximumSize=256";
    private static final Optional<String> COMPOSITE_SERVICE_CACHE_SPEC;
    private static final String DEFAULT_PARSED_PATH_CACHE_SPEC = "maximumSize=4096";
    private static final Optional<String> PARSED_PATH_CACHE_SPEC;
    private static final String DEFAULT_HEADER_VALUE_CACHE_SPEC = "maximumSize=4096";
    private static final Optional<String> HEADER_VALUE_CACHE_SPEC;
    private static final String DEFAULT_CACHED_HEADERS = ":authority,:scheme,:method,accept-encoding,content-type";
    private static final List<String> CACHED_HEADERS;
    private static final String DEFAULT_ANNOTATED_SERVICE_EXCEPTION_VERBOSITY = "unhandled";
    private static final ExceptionVerbosity ANNOTATED_SERVICE_EXCEPTION_VERBOSITY;

    private static boolean isEpollAvailable() {
        return Epoll.isAvailable() && !HAS_WSLENV;
    }

    public static boolean verboseExceptions() {
        return VERBOSE_EXCEPTIONS;
    }

    public static boolean verboseResponses() {
        return VERBOSE_RESPONSES;
    }

    public static boolean useEpoll() {
        return USE_EPOLL;
    }

    public static boolean useOpenSsl() {
        return USE_OPENSSL;
    }

    public static int maxNumConnections() {
        return MAX_NUM_CONNECTIONS;
    }

    public static int numCommonWorkers() {
        return NUM_COMMON_WORKERS;
    }

    public static int numCommonBlockingTaskThreads() {
        return NUM_COMMON_BLOCKING_TASK_THREADS;
    }

    public static long defaultMaxRequestLength() {
        return DEFAULT_MAX_REQUEST_LENGTH;
    }

    public static long defaultMaxResponseLength() {
        return DEFAULT_MAX_RESPONSE_LENGTH;
    }

    public static long defaultRequestTimeoutMillis() {
        return DEFAULT_REQUEST_TIMEOUT_MILLIS;
    }

    public static long defaultResponseTimeoutMillis() {
        return DEFAULT_RESPONSE_TIMEOUT_MILLIS;
    }

    public static long defaultConnectTimeoutMillis() {
        return DEFAULT_CONNECT_TIMEOUT_MILLIS;
    }

    public static long defaultServerIdleTimeoutMillis() {
        return DEFAULT_SERVER_IDLE_TIMEOUT_MILLIS;
    }

    public static long defaultClientIdleTimeoutMillis() {
        return DEFAULT_CLIENT_IDLE_TIMEOUT_MILLIS;
    }

    public static int defaultHttp1MaxInitialLineLength() {
        return DEFAULT_MAX_HTTP1_INITIAL_LINE_LENGTH;
    }

    public static int defaultHttp1MaxHeaderSize() {
        return DEFAULT_MAX_HTTP1_HEADER_SIZE;
    }

    public static int defaultHttp1MaxChunkSize() {
        return DEFAULT_HTTP1_MAX_CHUNK_SIZE;
    }

    public static boolean defaultUseHttp2Preface() {
        return DEFAULT_USE_HTTP2_PREFACE;
    }

    public static boolean defaultUseHttp1Pipelining() {
        return DEFAULT_USE_HTTP1_PIPELINING;
    }

    public static int defaultHttp2InitialConnectionWindowSize() {
        return DEFAULT_HTTP2_INITIAL_CONNECTION_WINDOW_SIZE;
    }

    public static int defaultHttp2InitialStreamWindowSize() {
        return DEFAULT_HTTP2_INITIAL_STREAM_WINDOW_SIZE;
    }

    public static int defaultHttp2MaxFrameSize() {
        return DEFAULT_HTTP2_MAX_FRAME_SIZE;
    }

    public static long defaultHttp2MaxStreamsPerConnection() {
        return DEFAULT_HTTP2_MAX_STREAMS_PER_CONNECTION;
    }

    public static long defaultHttp2MaxHeaderListSize() {
        return DEFAULT_HTTP2_MAX_HEADER_LIST_SIZE;
    }

    public static String defaultBackoffSpec() {
        return DEFAULT_BACKOFF_SPEC;
    }

    public static int defaultMaxTotalAttempts() {
        return DEFAULT_MAX_TOTAL_ATTEMPTS;
    }

    public static Optional<String> routeCacheSpec() {
        return ROUTE_CACHE_SPEC;
    }

    public static Optional<String> parsedPathCacheSpec() {
        return PARSED_PATH_CACHE_SPEC;
    }

    public static Optional<String> headerValueCacheSpec() {
        return HEADER_VALUE_CACHE_SPEC;
    }

    public static List<String> cachedHeaders() {
        return CACHED_HEADERS;
    }

    public static Optional<String> compositeServiceCacheSpec() {
        return COMPOSITE_SERVICE_CACHE_SPEC;
    }

    public static ExceptionVerbosity annotatedServiceExceptionVerbosity() {
        return ANNOTATED_SERVICE_EXCEPTION_VERBOSITY;
    }

    private static Optional<String> caffeineSpec(String name, String defaultValue) {
        String spec = Flags.get(name, defaultValue, value -> {
            try {
                if (!"off".equals(value)) {
                    CaffeineSpec.parse(value);
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
        return "off".equals(spec) ? Optional.empty() : Optional.of(spec);
    }

    private static ExceptionVerbosity exceptionLoggingMode(String name, String defaultValue) {
        String mode = Flags.getNormalized(name, defaultValue, value -> Arrays.stream(ExceptionVerbosity.values()).anyMatch(v -> v.name().equalsIgnoreCase((String)value)));
        return ExceptionVerbosity.valueOf(mode.toUpperCase());
    }

    private static boolean getBoolean(String name, boolean defaultValue) {
        return Flags.getBoolean(name, defaultValue, value -> true);
    }

    private static boolean getBoolean(String name, boolean defaultValue, Predicate<Boolean> validator) {
        return "true".equals(Flags.getNormalized(name, String.valueOf(defaultValue), value -> {
            if ("true".equals(value)) {
                return validator.test(true);
            }
            if ("false".equals(value)) {
                return validator.test(false);
            }
            return false;
        }));
    }

    private static int getInt(String name, int defaultValue, IntPredicate validator) {
        return Integer.parseInt(Flags.getNormalized(name, String.valueOf(defaultValue), value -> {
            try {
                return validator.test(Integer.parseInt(value));
            }
            catch (Exception e) {
                return false;
            }
        }));
    }

    private static long getLong(String name, long defaultValue, LongPredicate validator) {
        return Long.parseLong(Flags.getNormalized(name, String.valueOf(defaultValue), value -> {
            try {
                return validator.test(Long.parseLong(value));
            }
            catch (Exception e) {
                return false;
            }
        }));
    }

    private static String get(String name, String defaultValue, Predicate<String> validator) {
        String fullName = PREFIX + name;
        String value = System.getProperty(fullName);
        if (value == null) {
            logger.info("{}: {} (default)", (Object)fullName, (Object)defaultValue);
            return defaultValue;
        }
        if (validator.test(value)) {
            logger.info("{}: {}", (Object)fullName, (Object)value);
            return value;
        }
        logger.info("{}: {} (default instead of: {})", new Object[]{fullName, defaultValue, value});
        return defaultValue;
    }

    private static String getNormalized(String name, String defaultValue, Predicate<String> validator) {
        String fullName = PREFIX + name;
        String value = Flags.getLowerCased(fullName);
        if (value == null) {
            logger.info("{}: {} (default)", (Object)fullName, (Object)defaultValue);
            return defaultValue;
        }
        if (validator.test(value)) {
            logger.info("{}: {}", (Object)fullName, (Object)value);
            return value;
        }
        logger.info("{}: {} (default instead of: {})", new Object[]{fullName, defaultValue, value});
        return defaultValue;
    }

    @Nullable
    private static String getLowerCased(String fullName) {
        String value = System.getProperty(fullName);
        if (value != null) {
            value = Ascii.toLowerCase(value);
        }
        return value;
    }

    private Flags() {
    }

    static {
        Throwable cause;
        logger = LoggerFactory.getLogger(Flags.class);
        CSV_SPLITTER = Splitter.on(',').trimResults().omitEmptyStrings();
        NUM_CPU_CORES = Runtime.getRuntime().availableProcessors();
        VERBOSE_EXCEPTIONS = Flags.getBoolean("verboseExceptions", false);
        VERBOSE_RESPONSES = Flags.getBoolean("verboseResponses", false);
        HAS_WSLENV = System.getenv("WSLENV") != null;
        USE_EPOLL = Flags.getBoolean("useEpoll", Flags.isEpollAvailable(), value -> Flags.isEpollAvailable() || value == false);
        USE_OPENSSL = Flags.getBoolean("useOpenSsl", OpenSsl.isAvailable(), value -> OpenSsl.isAvailable() || value == false);
        MAX_NUM_CONNECTIONS = Flags.getInt("maxNumConnections", Integer.MAX_VALUE, value -> value > 0);
        DEFAULT_NUM_COMMON_WORKERS = NUM_CPU_CORES * 2;
        NUM_COMMON_WORKERS = Flags.getInt("numCommonWorkers", DEFAULT_NUM_COMMON_WORKERS, value -> value > 0);
        NUM_COMMON_BLOCKING_TASK_THREADS = Flags.getInt("numCommonBlockingTaskThreads", 200, value -> value > 0);
        DEFAULT_MAX_REQUEST_LENGTH = Flags.getLong("defaultMaxRequestLength", 0xA00000L, value -> value >= 0L);
        DEFAULT_MAX_RESPONSE_LENGTH = Flags.getLong("defaultMaxResponseLength", 0xA00000L, value -> value >= 0L);
        DEFAULT_REQUEST_TIMEOUT_MILLIS = Flags.getLong("defaultRequestTimeoutMillis", 10000L, value -> value >= 0L);
        DEFAULT_RESPONSE_TIMEOUT_MILLIS = Flags.getLong("defaultResponseTimeoutMillis", 15000L, value -> value >= 0L);
        DEFAULT_CONNECT_TIMEOUT_MILLIS = Flags.getLong("defaultConnectTimeoutMillis", 3200L, value -> value > 0L);
        DEFAULT_SERVER_IDLE_TIMEOUT_MILLIS = Flags.getLong("defaultServerIdleTimeoutMillis", 15000L, value -> value >= 0L);
        DEFAULT_CLIENT_IDLE_TIMEOUT_MILLIS = Flags.getLong("defaultClientIdleTimeoutMillis", 10000L, value -> value >= 0L);
        DEFAULT_HTTP2_INITIAL_CONNECTION_WINDOW_SIZE = Flags.getInt("defaultHttp2InitialConnectionWindowSize", 0x100000, value -> value > 0);
        DEFAULT_HTTP2_INITIAL_STREAM_WINDOW_SIZE = Flags.getInt("defaultHttp2InitialStreamWindowSize", 0x100000, value -> value > 0);
        DEFAULT_HTTP2_MAX_FRAME_SIZE = Flags.getInt("defaultHttp2MaxFrameSize", 16384, value -> value >= 16384 && value <= 0xFFFFFF);
        DEFAULT_HTTP2_MAX_STREAMS_PER_CONNECTION = Flags.getLong("defaultHttp2MaxStreamsPerConnection", Integer.MAX_VALUE, value -> value > 0L && value <= 0xFFFFFFFFL);
        DEFAULT_HTTP2_MAX_HEADER_LIST_SIZE = Flags.getLong("defaultHttp2MaxHeaderListSize", 8192L, value -> value > 0L && value <= 0xFFFFFFFFL);
        DEFAULT_MAX_HTTP1_INITIAL_LINE_LENGTH = Flags.getInt("defaultHttp1MaxInitialLineLength", 4096, value -> value >= 0);
        DEFAULT_MAX_HTTP1_HEADER_SIZE = Flags.getInt("defaultHttp1MaxHeaderSize", 8192, value -> value >= 0);
        DEFAULT_HTTP1_MAX_CHUNK_SIZE = Flags.getInt("defaultHttp1MaxChunkSize", 8192, value -> value >= 0);
        DEFAULT_USE_HTTP2_PREFACE = Flags.getBoolean("defaultUseHttp2Preface", true);
        DEFAULT_USE_HTTP1_PIPELINING = Flags.getBoolean("defaultUseHttp1Pipelining", false);
        DEFAULT_BACKOFF_SPEC = Flags.getNormalized("defaultBackoffSpec", DEFAULT_DEFAULT_BACKOFF_SPEC, value -> {
            try {
                Backoff.of(value);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
        DEFAULT_MAX_TOTAL_ATTEMPTS = Flags.getInt("defaultMaxTotalAttempts", 10, value -> value > 0);
        ROUTE_CACHE_SPEC = Flags.caffeineSpec("routeCache", "maximumSize=4096");
        COMPOSITE_SERVICE_CACHE_SPEC = Flags.caffeineSpec("compositeServiceCache", DEFAULT_COMPOSITE_SERVICE_CACHE_SPEC);
        PARSED_PATH_CACHE_SPEC = Flags.caffeineSpec("parsedPathCache", "maximumSize=4096");
        HEADER_VALUE_CACHE_SPEC = Flags.caffeineSpec("headerValueCache", "maximumSize=4096");
        CACHED_HEADERS = CSV_SPLITTER.splitToList(Flags.getNormalized("cachedHeaders", DEFAULT_CACHED_HEADERS, CharMatcher.ascii()::matchesAllOf));
        ANNOTATED_SERVICE_EXCEPTION_VERBOSITY = Flags.exceptionLoggingMode("annotatedServiceExceptionVerbosity", DEFAULT_ANNOTATED_SERVICE_EXCEPTION_VERBOSITY);
        if (!Flags.isEpollAvailable()) {
            cause = Epoll.unavailabilityCause();
            if (cause != null) {
                logger.info("/dev/epoll not available: {}", (Object)Exceptions.peel(cause).toString());
            } else if (HAS_WSLENV) {
                logger.info("/dev/epoll not available: WSL not supported");
            } else {
                logger.info("/dev/epoll not available: ?");
            }
        } else if (USE_EPOLL) {
            logger.info("Using /dev/epoll");
        }
        if (!OpenSsl.isAvailable()) {
            cause = Exceptions.peel(OpenSsl.unavailabilityCause());
            logger.info("OpenSSL not available: {}", (Object)cause.toString());
        } else if (USE_OPENSSL) {
            logger.info("Using OpenSSL: {}, 0x{}", (Object)OpenSsl.versionString(), (Object)Long.toHexString((long)OpenSsl.version() & 0xFFFFFFFFL));
        }
    }
}

