/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.DefaultHttpData;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.internal.shaded.fastutil.io.FastByteArrayInputStream;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;

public interface HttpData
extends HttpObject {
    public static final HttpData EMPTY_DATA = new DefaultHttpData(new byte[0], 0, 0, false);

    public static HttpData of(byte[] data) {
        Objects.requireNonNull(data, "data");
        if (data.length == 0) {
            return EMPTY_DATA;
        }
        return new DefaultHttpData(data, 0, data.length, false);
    }

    public static HttpData of(byte[] data, int offset, int length) {
        Objects.requireNonNull(data);
        if (offset < 0 || length < 0 || offset > data.length - length) {
            throw new ArrayIndexOutOfBoundsException("offset: " + offset + ", length: " + length + ", data.length: " + data.length);
        }
        if (length == 0) {
            return EMPTY_DATA;
        }
        return new DefaultHttpData(data, offset, length, false);
    }

    public static HttpData of(Charset charset, String text) {
        Objects.requireNonNull(charset, "charset");
        Objects.requireNonNull(text, "text");
        if (text.isEmpty()) {
            return EMPTY_DATA;
        }
        return HttpData.of(text.getBytes(charset));
    }

    public static HttpData of(ByteBuf buf) {
        Objects.requireNonNull(buf, "buf");
        if (!buf.isReadable()) {
            return EMPTY_DATA;
        }
        return HttpData.of(ByteBufUtil.getBytes((ByteBuf)buf));
    }

    public static HttpData of(Charset charset, String format, Object ... args) {
        Objects.requireNonNull(charset, "charset");
        Objects.requireNonNull(format, "format");
        Objects.requireNonNull(args, "args");
        if (format.isEmpty()) {
            return EMPTY_DATA;
        }
        return HttpData.of(String.format(Locale.ENGLISH, format, args).getBytes(charset));
    }

    public static HttpData ofUtf8(String text) {
        return HttpData.of(StandardCharsets.UTF_8, text);
    }

    public static HttpData ofUtf8(String format, Object ... args) {
        return HttpData.of(StandardCharsets.UTF_8, format, args);
    }

    public static HttpData ofAscii(String text) {
        return HttpData.of(StandardCharsets.US_ASCII, text);
    }

    public static HttpData ofAscii(String format, Object ... args) {
        return HttpData.of(StandardCharsets.US_ASCII, format, args);
    }

    public byte[] array();

    public int offset();

    public int length();

    default public boolean isEmpty() {
        return this.length() == 0;
    }

    default public String toString(Charset charset) {
        Objects.requireNonNull(charset, "charset");
        return new String(this.array(), this.offset(), this.length(), charset);
    }

    default public String toStringUtf8() {
        return this.toString(StandardCharsets.UTF_8);
    }

    default public String toStringAscii() {
        return this.toString(StandardCharsets.US_ASCII);
    }

    default public InputStream toInputStream() {
        return new FastByteArrayInputStream(this.array(), this.offset(), this.length());
    }

    default public Reader toReader(Charset charset) {
        Objects.requireNonNull(charset, "charset");
        return new InputStreamReader(this.toInputStream(), charset);
    }

    default public Reader toReaderUtf8() {
        return this.toReader(StandardCharsets.UTF_8);
    }

    default public Reader toReaderAscii() {
        return this.toReader(StandardCharsets.US_ASCII);
    }
}

