/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.linecorp.armeria.common.DefaultHttpHeaders;
import com.linecorp.armeria.common.HttpHeadersJsonDeserializer;
import com.linecorp.armeria.common.HttpHeadersJsonSerializer;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.ImmutableHttpHeaders;
import com.linecorp.armeria.common.MediaType;
import io.netty.handler.codec.Headers;
import io.netty.util.AsciiString;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonSerialize(using=HttpHeadersJsonSerializer.class)
@JsonDeserialize(using=HttpHeadersJsonDeserializer.class)
public interface HttpHeaders
extends HttpObject,
Headers<AsciiString, String, HttpHeaders> {
    public static final HttpHeaders EMPTY_HEADERS = new DefaultHttpHeaders(false, 0).asImmutable();

    public static HttpHeaders of() {
        return new DefaultHttpHeaders();
    }

    public static HttpHeaders of(HttpMethod method, String path) {
        return new DefaultHttpHeaders().method(method).path(path);
    }

    public static HttpHeaders of(int statusCode) {
        return HttpHeaders.of(HttpStatus.valueOf(statusCode));
    }

    public static HttpHeaders of(HttpStatus status) {
        return new DefaultHttpHeaders().status(status);
    }

    public static HttpHeaders of(AsciiString name, String value) {
        return (HttpHeaders)new DefaultHttpHeaders().add(name, value);
    }

    public static HttpHeaders of(AsciiString name1, String value1, AsciiString name2, String value2) {
        return (HttpHeaders)((HttpHeaders)new DefaultHttpHeaders().add(name1, value1)).add(name2, value2);
    }

    public static HttpHeaders of(AsciiString name1, String value1, AsciiString name2, String value2, AsciiString name3, String value3) {
        return (HttpHeaders)((HttpHeaders)((HttpHeaders)new DefaultHttpHeaders().add(name1, value1)).add(name2, value2)).add(name3, value3);
    }

    public static HttpHeaders of(AsciiString name1, String value1, AsciiString name2, String value2, AsciiString name3, String value3, AsciiString name4, String value4) {
        return (HttpHeaders)((HttpHeaders)((HttpHeaders)((HttpHeaders)new DefaultHttpHeaders().add(name1, value1)).add(name2, value2)).add(name3, value3)).add(name4, value4);
    }

    public static HttpHeaders copyOf(HttpHeaders headers) {
        return (HttpHeaders)HttpHeaders.of().set(Objects.requireNonNull(headers, "headers"));
    }

    public Iterator<Map.Entry<AsciiString, String>> iterator();

    @Nullable
    public HttpMethod method();

    public HttpHeaders method(HttpMethod var1);

    @Nullable
    public String scheme();

    public HttpHeaders scheme(String var1);

    @Nullable
    public String authority();

    public HttpHeaders authority(String var1);

    @Nullable
    public String path();

    public HttpHeaders path(String var1);

    @Nullable
    public HttpStatus status();

    public HttpHeaders status(int var1);

    public HttpHeaders status(HttpStatus var1);

    @Nullable
    public MediaType contentType();

    public HttpHeaders contentType(MediaType var1);

    default public HttpHeaders setAllIfAbsent(Headers<? extends AsciiString, ? extends String, ?> headers) {
        Objects.requireNonNull(headers, "headers");
        if (!headers.isEmpty()) {
            headers.forEach(entry -> {
                AsciiString name = (AsciiString)entry.getKey();
                if (!this.contains(name)) {
                    this.set(name, (String)entry.getValue());
                }
            });
        }
        return this;
    }

    default public HttpHeaders asImmutable() {
        return new ImmutableHttpHeaders(this);
    }

    default public boolean isImmutable() {
        return this instanceof ImmutableHttpHeaders;
    }
}

