/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import io.netty.util.AsciiString;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;

public final class HttpHeadersJsonDeserializer
extends StdDeserializer<HttpHeaders> {
    private static final long serialVersionUID = 6308506823069217145L;

    public HttpHeadersJsonDeserializer() {
        super(HttpHeaders.class);
    }

    @Nullable
    public HttpHeaders deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
        JsonNode tree = (JsonNode)p.getCodec().readTree(p);
        if (!tree.isObject()) {
            ctx.reportInputMismatch(HttpHeaders.class, "HTTP headers must be an object.", new Object[0]);
            return null;
        }
        ObjectNode obj = (ObjectNode)tree;
        HttpHeaders headers = HttpHeaders.of();
        Iterator i = obj.fields();
        while (i.hasNext()) {
            Map.Entry e = (Map.Entry)i.next();
            AsciiString name = HttpHeaderNames.of((String)e.getKey());
            JsonNode values = (JsonNode)e.getValue();
            if (!values.isArray()) {
                HttpHeadersJsonDeserializer.addHeader(ctx, headers, name, values);
                continue;
            }
            int numValues = values.size();
            for (int j = 0; j < numValues; ++j) {
                JsonNode v = values.get(j);
                HttpHeadersJsonDeserializer.addHeader(ctx, headers, name, v);
            }
        }
        return headers.asImmutable();
    }

    private static void addHeader(DeserializationContext ctx, HttpHeaders headers, AsciiString name, JsonNode valueNode) throws JsonMappingException {
        if (!valueNode.isTextual()) {
            ctx.reportInputMismatch(HttpHeaders.class, "HTTP header '%s' contains %s (%s); only strings are allowed.", new Object[]{name, valueNode.getNodeType(), valueNode});
        }
        headers.add(name, valueNode.asText());
    }
}

