/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.AggregatedHttpMessage;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.unsafe.ByteBufHttpData;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

abstract class HttpMessageAggregator
implements BiConsumer<Void, Throwable>,
Subscriber<HttpObject> {
    private final CompletableFuture<AggregatedHttpMessage> future;
    private final List<HttpData> contentList = new ArrayList<HttpData>();
    @Nullable
    private final ByteBufAllocator alloc;
    private int contentLength;
    @Nullable
    private Subscription subscription;

    HttpMessageAggregator(CompletableFuture<AggregatedHttpMessage> future, @Nullable ByteBufAllocator alloc) {
        this.future = future;
        this.alloc = alloc;
    }

    public final void onSubscribe(Subscription s) {
        this.subscription = s;
        s.request(Long.MAX_VALUE);
    }

    public final void onError(Throwable throwable) {
    }

    public final void onComplete() {
    }

    public final void onNext(HttpObject o) {
        if (o instanceof HttpHeaders) {
            this.onHeaders((HttpHeaders)o);
        } else {
            this.onData((HttpData)o);
        }
    }

    protected abstract void onHeaders(HttpHeaders var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onData(HttpData data) {
        boolean added = false;
        try {
            if (this.future.isDone()) {
                return;
            }
            int dataLength = data.length();
            if (dataLength > 0) {
                int allowedMaxDataLength = Integer.MAX_VALUE - this.contentLength;
                if (dataLength > allowedMaxDataLength) {
                    this.subscription.cancel();
                    this.fail(new IllegalStateException("content length greater than Integer.MAX_VALUE"));
                    return;
                }
                this.contentList.add(data);
                this.contentLength += dataLength;
                added = true;
            }
        }
        finally {
            if (!added) {
                ReferenceCountUtil.safeRelease((Object)data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(Void unused, Throwable cause) {
        Object merged;
        HttpData content;
        if (cause != null) {
            this.fail(cause);
            return;
        }
        if (this.contentLength == 0) {
            content = HttpData.EMPTY_DATA;
        } else if (this.alloc != null) {
            merged = this.alloc.buffer(this.contentLength);
            for (int i = 0; i < this.contentList.size(); ++i) {
                HttpData data = this.contentList.set(i, null);
                if (data instanceof ByteBufHolder) {
                    ByteBufHolder byteBufData = (ByteBufHolder)data;
                    try {
                        merged.writeBytes(byteBufData.content());
                        continue;
                    }
                    finally {
                        byteBufData.release();
                    }
                }
                merged.writeBytes(data.array(), data.offset(), data.length());
            }
            content = new ByteBufHttpData((ByteBuf)merged, true);
        } else {
            merged = new byte[this.contentLength];
            int offset = 0;
            for (int i = 0; i < this.contentList.size(); ++i) {
                HttpData data = this.contentList.set(i, null);
                int dataLength = data.length();
                System.arraycopy(data.array(), data.offset(), merged, offset, dataLength);
                offset += dataLength;
            }
            content = HttpData.of(merged);
        }
        try {
            this.future.complete(this.onSuccess(content));
        }
        catch (Throwable e) {
            this.future.completeExceptionally(e);
        }
    }

    private void fail(Throwable cause) {
        this.contentList.forEach(ReferenceCountUtil::safeRelease);
        this.contentList.clear();
        this.onFailure();
        this.future.completeExceptionally(cause);
    }

    protected abstract AggregatedHttpMessage onSuccess(HttpData var1);

    protected abstract void onFailure();
}

