/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.AggregatedHttpMessage;
import com.linecorp.armeria.common.DefaultHttpRequest;
import com.linecorp.armeria.common.FixedHttpRequest;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpRequestAggregator;
import com.linecorp.armeria.common.HttpRequestWriter;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.PublisherBasedHttpRequest;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.stream.StreamMessage;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.concurrent.EventExecutor;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import org.reactivestreams.Publisher;

public interface HttpRequest
extends Request,
StreamMessage<HttpObject> {
    public static HttpRequestWriter streaming(HttpMethod method, String path) {
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(path, "path");
        return HttpRequest.streaming(HttpHeaders.of(method, path));
    }

    public static HttpRequestWriter streaming(HttpHeaders headers) {
        Objects.requireNonNull(headers, "headers");
        return new DefaultHttpRequest(headers);
    }

    public static HttpRequest of(HttpMethod method, String path) {
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(path, "path");
        return HttpRequest.of(HttpHeaders.of(method, path));
    }

    public static HttpRequest of(HttpMethod method, String path, MediaType mediaType, String content) {
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(mediaType, "mediaType");
        return HttpRequest.of(method, path, mediaType, content.getBytes(mediaType.charset().orElse(StandardCharsets.UTF_8)));
    }

    public static HttpRequest of(HttpMethod method, String path, MediaType mediaType, String format, Object ... args) {
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(path, "path");
        return HttpRequest.of(method, path, mediaType, String.format(Locale.ENGLISH, format, args).getBytes(mediaType.charset().orElse(StandardCharsets.UTF_8)));
    }

    public static HttpRequest of(HttpMethod method, String path, MediaType mediaType, byte[] content) {
        Objects.requireNonNull(content, "content");
        return HttpRequest.of(method, path, mediaType, HttpData.of(content));
    }

    public static HttpRequest of(HttpMethod method, String path, MediaType mediaType, byte[] content, int offset, int length) {
        Objects.requireNonNull(content, "content");
        return HttpRequest.of(method, path, mediaType, HttpData.of(content, offset, length));
    }

    public static HttpRequest of(HttpMethod method, String path, MediaType mediaType, HttpData content) {
        return HttpRequest.of(method, path, mediaType, content, HttpHeaders.EMPTY_HEADERS);
    }

    public static HttpRequest of(HttpMethod method, String path, MediaType mediaType, HttpData content, HttpHeaders trailingHeaders) {
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(mediaType, "mediaType");
        return HttpRequest.of(HttpHeaders.of(method, path).contentType(mediaType), content, trailingHeaders);
    }

    public static HttpRequest of(HttpHeaders headers) {
        return HttpRequest.of(headers, HttpData.EMPTY_DATA);
    }

    public static HttpRequest of(HttpHeaders headers, HttpData content) {
        return HttpRequest.of(headers, content, HttpHeaders.EMPTY_HEADERS);
    }

    public static HttpRequest of(HttpHeaders headers, HttpData content, HttpHeaders trailingHeaders) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(trailingHeaders, "trailingHeaders");
        if (headers.method() == null) {
            throw new IllegalStateException("not a request (missing :method)");
        }
        if (headers.path() == null) {
            throw new IllegalStateException("not a request (missing :path)");
        }
        if (content.isEmpty()) {
            headers.remove(HttpHeaderNames.CONTENT_LENGTH);
        } else {
            headers.setInt(HttpHeaderNames.CONTENT_LENGTH, content.length());
        }
        if (!content.isEmpty()) {
            if (trailingHeaders.isEmpty()) {
                return new FixedHttpRequest.OneElementFixedHttpRequest(headers, content);
            }
            return new FixedHttpRequest.TwoElementFixedHttpRequest(headers, content, trailingHeaders);
        }
        if (!trailingHeaders.isEmpty()) {
            return new FixedHttpRequest.OneElementFixedHttpRequest(headers, trailingHeaders);
        }
        return new FixedHttpRequest.EmptyFixedHttpRequest(headers);
    }

    public static HttpRequest of(HttpHeaders headers, HttpObject ... objs) {
        if (Arrays.stream(objs).anyMatch(obj -> obj instanceof HttpHeaders)) {
            throw new IllegalArgumentException("objs contains HttpHeaders, which is not allowed.");
        }
        switch (objs.length) {
            case 0: {
                return new FixedHttpRequest.EmptyFixedHttpRequest(headers);
            }
            case 1: {
                return new FixedHttpRequest.OneElementFixedHttpRequest(headers, objs[0]);
            }
            case 2: {
                return new FixedHttpRequest.TwoElementFixedHttpRequest(headers, objs[0], objs[1]);
            }
        }
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] != null) continue;
            throw new NullPointerException("objs[" + i + "] is null");
        }
        return new FixedHttpRequest.RegularFixedHttpRequest(headers, objs);
    }

    public static HttpRequest of(AggregatedHttpMessage message) {
        return HttpRequest.of(message.headers(), message.content(), message.trailingHeaders());
    }

    public static HttpRequest of(HttpHeaders headers, Publisher<? extends HttpObject> publisher) {
        Objects.requireNonNull(publisher, "publisher");
        return new PublisherBasedHttpRequest(headers, publisher);
    }

    public HttpHeaders headers();

    default public String scheme() {
        return this.headers().scheme();
    }

    default public HttpRequest scheme(String scheme) {
        this.headers().scheme(scheme);
        return this;
    }

    default public HttpMethod method() {
        return this.headers().method();
    }

    default public HttpRequest method(HttpMethod method) {
        this.headers().method(method);
        return this;
    }

    default public String path() {
        return this.headers().path();
    }

    default public HttpRequest path(String path) {
        this.headers().path(path);
        return this;
    }

    default public String authority() {
        return this.headers().authority();
    }

    default public HttpRequest authority(String authority) {
        this.headers().authority(authority);
        return this;
    }

    default public CompletableFuture<AggregatedHttpMessage> aggregate() {
        CompletableFuture<AggregatedHttpMessage> future = new CompletableFuture<AggregatedHttpMessage>();
        HttpRequestAggregator aggregator = new HttpRequestAggregator(this, future, null);
        this.completionFuture().whenComplete((BiConsumer)aggregator);
        this.subscribe(aggregator);
        return future;
    }

    default public CompletableFuture<AggregatedHttpMessage> aggregate(EventExecutor executor) {
        Objects.requireNonNull(executor, "executor");
        CompletableFuture<AggregatedHttpMessage> future = new CompletableFuture<AggregatedHttpMessage>();
        HttpRequestAggregator aggregator = new HttpRequestAggregator(this, future, null);
        this.completionFuture().whenCompleteAsync((BiConsumer)aggregator, (Executor)executor);
        this.subscribe(aggregator, executor);
        return future;
    }

    default public CompletableFuture<AggregatedHttpMessage> aggregateWithPooledObjects(ByteBufAllocator alloc) {
        Objects.requireNonNull(alloc, "alloc");
        CompletableFuture<AggregatedHttpMessage> future = new CompletableFuture<AggregatedHttpMessage>();
        HttpRequestAggregator aggregator = new HttpRequestAggregator(this, future, alloc);
        this.completionFuture().whenComplete((BiConsumer)aggregator);
        this.subscribe(aggregator, true);
        return future;
    }

    default public CompletableFuture<AggregatedHttpMessage> aggregateWithPooledObjects(EventExecutor executor, ByteBufAllocator alloc) {
        Objects.requireNonNull(executor, "executor");
        Objects.requireNonNull(alloc, "alloc");
        CompletableFuture<AggregatedHttpMessage> future = new CompletableFuture<AggregatedHttpMessage>();
        HttpRequestAggregator aggregator = new HttpRequestAggregator(this, future, alloc);
        this.completionFuture().whenCompleteAsync((BiConsumer)aggregator, (Executor)executor);
        this.subscribe(aggregator, executor, true);
        return future;
    }
}

