/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.AggregatedHttpMessage;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMessageAggregator;
import com.linecorp.armeria.common.HttpRequest;
import io.netty.buffer.ByteBufAllocator;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

final class HttpRequestAggregator
extends HttpMessageAggregator {
    private final HttpRequest request;
    private HttpHeaders trailingHeaders;

    HttpRequestAggregator(HttpRequest request, CompletableFuture<AggregatedHttpMessage> future, @Nullable ByteBufAllocator alloc) {
        super(future, alloc);
        this.request = request;
        this.trailingHeaders = HttpHeaders.EMPTY_HEADERS;
    }

    @Override
    protected void onHeaders(HttpHeaders headers) {
        if (headers.isEmpty()) {
            return;
        }
        if (this.trailingHeaders.isEmpty()) {
            this.trailingHeaders = headers;
        } else {
            this.trailingHeaders.add(headers);
        }
    }

    @Override
    protected AggregatedHttpMessage onSuccess(HttpData content) {
        return AggregatedHttpMessage.of(this.request.headers(), content, this.trailingHeaders);
    }

    @Override
    protected void onFailure() {
        this.trailingHeaders = HttpHeaders.EMPTY_HEADERS;
    }
}

