/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.stream.AbstractStreamMessageDuplicator;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.stream.StreamMessageWrapper;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import io.netty.util.concurrent.EventExecutor;
import java.util.Objects;
import javax.annotation.Nullable;

public class HttpRequestDuplicator
extends AbstractStreamMessageDuplicator<HttpObject, HttpRequest> {
    private final HttpHeaders headers;

    public HttpRequestDuplicator(HttpRequest req) {
        this(req, Flags.defaultMaxRequestLength());
    }

    public HttpRequestDuplicator(HttpRequest req, long maxSignalLength) {
        this(req, maxSignalLength, null);
    }

    public HttpRequestDuplicator(HttpRequest req, long maxSignalLength, @Nullable EventExecutor executor) {
        super(Objects.requireNonNull(req, "req"), obj -> {
            if (obj instanceof HttpData) {
                return ((HttpData)obj).length();
            }
            return 0;
        }, executor, maxSignalLength);
        this.headers = req.headers();
    }

    @Override
    protected HttpRequest doDuplicateStream(StreamMessage<HttpObject> delegate) {
        return new DuplicateHttpRequest(delegate);
    }

    private class DuplicateHttpRequest
    extends StreamMessageWrapper<HttpObject>
    implements HttpRequest {
        DuplicateHttpRequest(StreamMessage<? extends HttpObject> delegate) {
            super(delegate);
        }

        @Override
        public HttpHeaders headers() {
            return HttpRequestDuplicator.this.headers;
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this).addValue(this.headers()).toString();
        }
    }
}

