/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.AggregatedHttpMessage;
import com.linecorp.armeria.common.DefaultHttpResponse;
import com.linecorp.armeria.common.DeferredHttpResponse;
import com.linecorp.armeria.common.FixedHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpResponseAggregator;
import com.linecorp.armeria.common.HttpResponseWriter;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.HttpStatusClass;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.PublisherBasedHttpResponse;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.ArmeriaHttpUtil;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import org.reactivestreams.Publisher;

public interface HttpResponse
extends Response,
StreamMessage<HttpObject> {
    public static HttpResponseWriter streaming() {
        return new DefaultHttpResponse();
    }

    public static HttpResponse from(CompletionStage<? extends HttpResponse> stage) {
        Objects.requireNonNull(stage, "stage");
        DeferredHttpResponse res = new DeferredHttpResponse();
        stage.whenComplete((delegate, thrown) -> {
            if (thrown != null) {
                res.close(Exceptions.peel(thrown));
            } else if (delegate == null) {
                res.close(new NullPointerException("delegate stage produced a null response: " + stage));
            } else {
                res.delegate((HttpResponse)delegate);
            }
        });
        return res;
    }

    public static HttpResponse of(int statusCode) {
        return HttpResponse.of(HttpStatus.valueOf(statusCode));
    }

    public static HttpResponse of(HttpStatus status) {
        Objects.requireNonNull(status, "status");
        if (status.codeClass() == HttpStatusClass.INFORMATIONAL) {
            HttpResponseWriter res = HttpResponse.streaming();
            res.write(HttpHeaders.of(status));
            return res;
        }
        if (ArmeriaHttpUtil.isContentAlwaysEmpty(status)) {
            return new FixedHttpResponse.OneElementFixedHttpResponse(HttpHeaders.of(status));
        }
        return HttpResponse.of(status, MediaType.PLAIN_TEXT_UTF_8, status.toHttpData());
    }

    public static HttpResponse of(HttpStatus status, MediaType mediaType, String content) {
        return HttpResponse.of(status, mediaType, content.getBytes(mediaType.charset().orElse(StandardCharsets.UTF_8)));
    }

    public static HttpResponse of(String content) {
        return HttpResponse.of(HttpStatus.OK, MediaType.PLAIN_TEXT_UTF_8, content);
    }

    public static HttpResponse of(String format, Object ... args) {
        return HttpResponse.of(HttpStatus.OK, MediaType.PLAIN_TEXT_UTF_8, format, args);
    }

    public static HttpResponse of(MediaType mediaType, String content) {
        return HttpResponse.of(HttpStatus.OK, mediaType, content);
    }

    public static HttpResponse of(MediaType mediaType, String format, Object ... args) {
        return HttpResponse.of(HttpStatus.OK, mediaType, format, args);
    }

    public static HttpResponse of(HttpStatus status, MediaType mediaType, String format, Object ... args) {
        return HttpResponse.of(status, mediaType, String.format(Locale.ENGLISH, format, args).getBytes(mediaType.charset().orElse(StandardCharsets.UTF_8)));
    }

    public static HttpResponse of(HttpStatus status, MediaType mediaType, byte[] content) {
        return HttpResponse.of(status, mediaType, HttpData.of(content));
    }

    public static HttpResponse of(HttpStatus status, MediaType mediaType, byte[] content, int offset, int length) {
        return HttpResponse.of(status, mediaType, HttpData.of(content, offset, length));
    }

    public static HttpResponse of(HttpStatus status, MediaType mediaType, HttpData content) {
        return HttpResponse.of(status, mediaType, content, HttpHeaders.EMPTY_HEADERS);
    }

    public static HttpResponse of(HttpStatus status, MediaType mediaType, HttpData content, HttpHeaders trailingHeaders) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(content, "content");
        HttpHeaders headers = (HttpHeaders)HttpHeaders.of(status).contentType(mediaType).setInt(HttpHeaderNames.CONTENT_LENGTH, content.length());
        return HttpResponse.of(headers, content, trailingHeaders);
    }

    public static HttpResponse of(HttpHeaders headers) {
        return HttpResponse.of(headers, HttpData.EMPTY_DATA);
    }

    public static HttpResponse of(HttpHeaders headers, HttpData content) {
        return HttpResponse.of(headers, content, HttpHeaders.EMPTY_HEADERS);
    }

    public static HttpResponse of(HttpHeaders headers, HttpData content, HttpHeaders trailingHeaders) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(trailingHeaders, "trailingHeaders");
        HttpStatus status = headers.status();
        if (status == null) {
            throw new IllegalStateException("not a response (missing :status)");
        }
        if (ArmeriaHttpUtil.isContentAlwaysEmptyWithValidation(status, content, trailingHeaders)) {
            ReferenceCountUtil.safeRelease((Object)content);
            return new FixedHttpResponse.OneElementFixedHttpResponse(headers);
        }
        if (!content.isEmpty()) {
            if (trailingHeaders.isEmpty()) {
                return new FixedHttpResponse.TwoElementFixedHttpResponse(headers, content);
            }
            return new FixedHttpResponse.RegularFixedHttpResponse(headers, content, trailingHeaders);
        }
        if (!trailingHeaders.isEmpty()) {
            return new FixedHttpResponse.TwoElementFixedHttpResponse(headers, trailingHeaders);
        }
        return new FixedHttpResponse.OneElementFixedHttpResponse(headers);
    }

    public static HttpResponse of(HttpObject ... objs) {
        Objects.requireNonNull(objs, "objs");
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] != null) continue;
            throw new NullPointerException("objs[" + i + "] is null");
        }
        return new FixedHttpResponse.RegularFixedHttpResponse(objs);
    }

    public static HttpResponse of(AggregatedHttpMessage res) {
        Objects.requireNonNull(res, "res");
        List<HttpHeaders> informationals = res.informationals();
        HttpHeaders headers = res.headers();
        HttpData content = res.content();
        HttpHeaders trailingHeaders = res.trailingHeaders();
        if (informationals.isEmpty()) {
            return HttpResponse.of(headers, content, trailingHeaders);
        }
        int numObjects = informationals.size() + 1 + (!content.isEmpty() ? 1 : 0) + (!trailingHeaders.isEmpty() ? 1 : 0);
        HttpObject[] objs = new HttpObject[numObjects];
        int writerIndex = 0;
        for (HttpHeaders informational : informationals) {
            objs[writerIndex++] = informational;
        }
        objs[writerIndex++] = headers;
        if (!content.isEmpty()) {
            objs[writerIndex++] = content;
        }
        if (!trailingHeaders.isEmpty()) {
            objs[writerIndex] = trailingHeaders;
        }
        return new FixedHttpResponse.RegularFixedHttpResponse(objs);
    }

    public static HttpResponse of(Publisher<? extends HttpObject> publisher) {
        return new PublisherBasedHttpResponse(publisher);
    }

    public static HttpResponse ofFailure(Throwable cause) {
        HttpResponseWriter res = HttpResponse.streaming();
        res.close(cause);
        return res;
    }

    @Deprecated
    public static HttpResponse ofFailed(Throwable cause) {
        return HttpResponse.ofFailure(cause);
    }

    @Override
    default public CompletableFuture<Void> closeFuture() {
        return this.completionFuture();
    }

    @Override
    public CompletableFuture<Void> completionFuture();

    default public CompletableFuture<AggregatedHttpMessage> aggregate() {
        CompletableFuture<AggregatedHttpMessage> future = new CompletableFuture<AggregatedHttpMessage>();
        HttpResponseAggregator aggregator = new HttpResponseAggregator(future, null);
        this.completionFuture().whenComplete((BiConsumer)aggregator);
        this.subscribe(aggregator);
        return future;
    }

    default public CompletableFuture<AggregatedHttpMessage> aggregate(EventExecutor executor) {
        CompletableFuture<AggregatedHttpMessage> future = new CompletableFuture<AggregatedHttpMessage>();
        HttpResponseAggregator aggregator = new HttpResponseAggregator(future, null);
        this.completionFuture().whenCompleteAsync((BiConsumer)aggregator, (Executor)executor);
        this.subscribe(aggregator, executor);
        return future;
    }

    default public CompletableFuture<AggregatedHttpMessage> aggregateWithPooledObjects(ByteBufAllocator alloc) {
        Objects.requireNonNull(alloc, "alloc");
        CompletableFuture<AggregatedHttpMessage> future = new CompletableFuture<AggregatedHttpMessage>();
        HttpResponseAggregator aggregator = new HttpResponseAggregator(future, alloc);
        this.completionFuture().whenComplete((BiConsumer)aggregator);
        this.subscribe(aggregator, true);
        return future;
    }

    default public CompletableFuture<AggregatedHttpMessage> aggregateWithPooledObjects(EventExecutor executor, ByteBufAllocator alloc) {
        Objects.requireNonNull(executor, "executor");
        Objects.requireNonNull(alloc, "alloc");
        CompletableFuture<AggregatedHttpMessage> future = new CompletableFuture<AggregatedHttpMessage>();
        HttpResponseAggregator aggregator = new HttpResponseAggregator(future, alloc);
        this.completionFuture().whenCompleteAsync((BiConsumer)aggregator, (Executor)executor);
        this.subscribe(aggregator, executor, true);
        return future;
    }
}

