/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.AggregatedHttpMessage;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMessageAggregator;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.HttpStatusClass;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import io.netty.buffer.ByteBufAllocator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

final class HttpResponseAggregator
extends HttpMessageAggregator {
    @Nullable
    private List<HttpHeaders> informationals;
    @Nullable
    private HttpHeaders headers;
    private HttpHeaders trailingHeaders;
    private State state = State.WAIT_NON_INFORMATIONAL;

    HttpResponseAggregator(CompletableFuture<AggregatedHttpMessage> future, @Nullable ByteBufAllocator alloc) {
        super(future, alloc);
        this.trailingHeaders = HttpHeaders.EMPTY_HEADERS;
    }

    @Override
    protected void onHeaders(HttpHeaders headers) {
        switch (this.state) {
            case WAIT_NON_INFORMATIONAL: {
                HttpStatus status = headers.status();
                if (status != null && status.codeClass() != HttpStatusClass.INFORMATIONAL) {
                    this.state = State.WAIT_CONTENT;
                } else {
                    if (this.informationals == null) {
                        this.informationals = new ArrayList<HttpHeaders>(2);
                        this.informationals.add(headers);
                        break;
                    }
                    if (status != null) {
                        this.informationals.add(headers);
                        break;
                    }
                    this.informationals.get(this.informationals.size() - 1).add(headers);
                    break;
                }
            }
            case WAIT_CONTENT: {
                if (this.headers == null) {
                    this.headers = headers;
                    break;
                }
                this.headers.add(headers);
                break;
            }
            case WAIT_TRAILERS: {
                if (headers.isEmpty()) break;
                if (this.trailingHeaders.isEmpty()) {
                    this.trailingHeaders = headers;
                    break;
                }
                this.trailingHeaders.add(headers);
            }
        }
    }

    @Override
    protected void onData(HttpData data) {
        this.state = State.WAIT_TRAILERS;
        super.onData(data);
    }

    @Override
    protected AggregatedHttpMessage onSuccess(HttpData content) {
        Preconditions.checkState(this.headers != null, "An aggregated message does not have headers.");
        return AggregatedHttpMessage.of(MoreObjects.firstNonNull(this.informationals, Collections.emptyList()), this.headers, content, this.trailingHeaders);
    }

    @Override
    protected void onFailure() {
        this.headers = null;
        this.trailingHeaders = HttpHeaders.EMPTY_HEADERS;
    }

    static enum State {
        WAIT_NON_INFORMATIONAL,
        WAIT_CONTENT,
        WAIT_TRAILERS;

    }
}

