/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.stream.AbstractStreamMessageDuplicator;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.stream.StreamMessageWrapper;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import io.netty.util.concurrent.EventExecutor;
import java.util.Objects;
import javax.annotation.Nullable;

public class HttpResponseDuplicator
extends AbstractStreamMessageDuplicator<HttpObject, HttpResponse> {
    public HttpResponseDuplicator(HttpResponse res) {
        this(res, Flags.defaultMaxResponseLength());
    }

    public HttpResponseDuplicator(HttpResponse res, long maxSignalLength) {
        this(res, maxSignalLength, null);
    }

    public HttpResponseDuplicator(HttpResponse res, long maxSignalLength, @Nullable EventExecutor executor) {
        super(Objects.requireNonNull(res, "res"), obj -> {
            if (obj instanceof HttpData) {
                return ((HttpData)obj).length();
            }
            return 0;
        }, executor, maxSignalLength);
    }

    @Override
    protected HttpResponse doDuplicateStream(StreamMessage<HttpObject> delegate) {
        return new DuplicateHttpResponse((StreamMessage<? extends HttpObject>)delegate);
    }

    private static class DuplicateHttpResponse
    extends StreamMessageWrapper<HttpObject>
    implements HttpResponse {
        DuplicateHttpResponse(StreamMessage<? extends HttpObject> delegate) {
            super(delegate);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this).toString();
        }
    }
}

