/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.AggregatedHttpMessage;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.HttpStatusClass;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.stream.StreamWriter;
import com.linecorp.armeria.internal.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import io.netty.util.ReferenceCountUtil;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;

public interface HttpResponseWriter
extends HttpResponse,
StreamWriter<HttpObject> {
    @Deprecated
    default public void respond(int statusCode) {
        this.respond(HttpStatus.valueOf(statusCode));
    }

    @Deprecated
    default public void respond(HttpStatus status) {
        Objects.requireNonNull(status, "status");
        if (status.codeClass() == HttpStatusClass.INFORMATIONAL) {
            this.write(HttpHeaders.of(status));
        } else if (ArmeriaHttpUtil.isContentAlwaysEmpty(status)) {
            this.write(HttpHeaders.of(status));
            this.close();
        } else {
            this.respond(status, MediaType.PLAIN_TEXT_UTF_8, status.toHttpData());
        }
    }

    @Deprecated
    default public void respond(HttpStatus status, MediaType mediaType, String content) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(content, "content");
        this.respond(status, mediaType, content.getBytes(mediaType.charset().orElse(StandardCharsets.UTF_8)));
    }

    @Deprecated
    default public void respond(HttpStatus status, MediaType mediaType, String format, Object ... args) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(format, "format");
        Objects.requireNonNull(args, "args");
        this.respond(status, mediaType, String.format(Locale.ENGLISH, format, args).getBytes(mediaType.charset().orElse(StandardCharsets.UTF_8)));
    }

    @Deprecated
    default public void respond(HttpStatus status, MediaType mediaType, byte[] content) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(content, "content");
        this.respond(status, mediaType, HttpData.of(content));
    }

    @Deprecated
    default public void respond(HttpStatus status, MediaType mediaType, byte[] content, int offset, int length) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(content, "content");
        this.respond(status, mediaType, HttpData.of(content, offset, length));
    }

    @Deprecated
    default public void respond(HttpStatus status, MediaType mediaType, HttpData content) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(content, "content");
        this.respond(status, mediaType, content, HttpHeaders.EMPTY_HEADERS);
    }

    @Deprecated
    default public void respond(HttpStatus status, MediaType mediaType, HttpData content, HttpHeaders trailingHeaders) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(trailingHeaders, "trailingHeaders");
        HttpHeaders headers = (HttpHeaders)HttpHeaders.of(status).contentType(mediaType).setInt(HttpHeaderNames.CONTENT_LENGTH, content.length());
        if (ArmeriaHttpUtil.isContentAlwaysEmptyWithValidation(status, content, trailingHeaders)) {
            ReferenceCountUtil.safeRelease((Object)content);
            this.write(headers);
        } else {
            this.write(headers);
            if (!content.isEmpty()) {
                this.write(content);
            }
        }
        if (!trailingHeaders.isEmpty()) {
            this.write(trailingHeaders);
        }
        this.close();
    }

    @Deprecated
    default public void respond(AggregatedHttpMessage res) {
        this.close(res);
    }

    @Override
    default public void close(AggregatedHttpMessage res) {
        Objects.requireNonNull(res, "res");
        HttpHeaders headers = res.headers();
        HttpStatus status = headers.status();
        Preconditions.checkArgument(status != null, "res does not contain :status.");
        HttpData content = res.content();
        HttpHeaders trailingHeaders = res.trailingHeaders();
        if (ArmeriaHttpUtil.isContentAlwaysEmptyWithValidation(status, content, trailingHeaders)) {
            ReferenceCountUtil.safeRelease((Object)content);
            this.write(headers);
        } else {
            this.write(headers);
            if (!content.isEmpty()) {
                this.write(content);
            }
        }
        if (!trailingHeaders.isEmpty()) {
            this.write(trailingHeaders);
        }
        this.close();
    }
}

